/* rygel-http-response.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-response.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_DATA_SINK (rygel_data_sink_get_type ())
#define RYGEL_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SINK, RygelDataSink))
#define RYGEL_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATA_SINK, RygelDataSinkClass))
#define RYGEL_IS_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SINK))
#define RYGEL_IS_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATA_SINK))
#define RYGEL_DATA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATA_SINK, RygelDataSinkClass))

typedef struct _RygelDataSink RygelDataSink;
typedef struct _RygelDataSinkClass RygelDataSinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelHTTPResponsePrivate {
	SoupServer* _server;
	GCancellable* _cancellable;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gint _priority;
	RygelDataSource* src;
	RygelDataSink* sink;
	gboolean unref_soup_server;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_DATA_SOURCE_ERROR_GENERAL,
	RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED,
	RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED
} RygelDataSourceError;
#define RYGEL_DATA_SOURCE_ERROR rygel_data_source_error_quark ()
struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	RygelDataSource* _tmp0_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;

GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_data_sink_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_SERVER,
	RYGEL_HTTP_RESPONSE_CANCELLABLE,
	RYGEL_HTTP_RESPONSE_PRIORITY
};
SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self);
static void rygel_http_response_on_server_weak_ref (RygelHTTPResponse* self, GObject* object);
static void _rygel_http_response_on_server_weak_ref_gweak_notify (gpointer self, GObject* object);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
static void rygel_http_response_set_server (RygelHTTPResponse* self, SoupServer* value);
GCancellable* rygel_http_get_handler_get_cancellable (RygelHTTPGetHandler* self);
RygelDataSink* rygel_data_sink_new (RygelDataSource* source, SoupServer* server, SoupMessage* message, RygelHTTPSeekRequest* offsets);
RygelDataSink* rygel_data_sink_construct (GType object_type, RygelDataSource* source, SoupServer* server, SoupMessage* message, RygelHTTPSeekRequest* offsets);
static void __lambda6_ (RygelHTTPResponse* self);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static void ___lambda6__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void __lambda7_ (RygelHTTPResponse* self, GError* _error_);
GQuark rygel_data_source_error_quark (void);
static void ___lambda7__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self);
static void rygel_http_response_on_cancelled (RygelHTTPResponse* self, GCancellable* cancellable);
static void _rygel_http_response_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
GeeList* rygel_http_response_preroll (RygelHTTPResponse* self, GError** error);
GeeList* rygel_data_source_preroll (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
void rygel_data_source_start (RygelDataSource* self, GError** error);
static gboolean ___lambda8_ (RygelHTTPResponse* self);
static gboolean ____lambda8__gsource_func (gpointer self);
static void rygel_http_response_real_end (RygelHTTPResponse* self, gboolean aborted, guint status);
void rygel_data_source_stop (RygelDataSource* self);
gint rygel_http_response_get_priority (RygelHTTPResponse* self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_http_response_on_server_weak_ref_gweak_notify (gpointer self, GObject* object) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_on_server_weak_ref ((RygelHTTPResponse*) self, object);
#line 320 "rygel-http-response.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return self ? g_object_ref (self) : NULL;
#line 327 "rygel-http-response.c"
}


static void __lambda6_ (RygelHTTPResponse* self) {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
#line 334 "rygel-http-response.c"
}


static void ___lambda6__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	__lambda6_ ((RygelHTTPResponse*) self);
#line 341 "rygel-http-response.c"
}


static void __lambda7_ (RygelHTTPResponse* self, GError* _error_) {
	GError* _tmp0_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = _error_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (g_error_matches (_tmp0_, RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED)) {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 353 "rygel-http-response.c"
	} else {
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
#line 357 "rygel-http-response.c"
	}
}


static void ___lambda7__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	__lambda7_ ((RygelHTTPResponse*) self, _error_);
#line 365 "rygel-http-response.c"
}


static void _rygel_http_response_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_on_cancelled ((RygelHTTPResponse*) self, _sender);
#line 372 "rygel-http-response.c"
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error) {
	RygelHTTPResponse * self = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	RygelHTTPGet* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	SoupMessage* _tmp4_ = NULL;
	RygelHTTPGetHandler* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	RygelHTTPGet* _tmp8_ = NULL;
	RygelHTTPSeekRequest* _tmp9_ = NULL;
	RygelHTTPSeekRequest* _tmp10_ = NULL;
	RygelHTTPGet* _tmp11_ = NULL;
	RygelPlaySpeedRequest* _tmp12_ = NULL;
	RygelPlaySpeedRequest* _tmp13_ = NULL;
	RygelDataSource* _tmp14_ = NULL;
	RygelDataSource* _tmp15_ = NULL;
	RygelDataSource* _tmp16_ = NULL;
	SoupServer* _tmp17_ = NULL;
	SoupMessage* _tmp18_ = NULL;
	RygelHTTPSeekRequest* _tmp19_ = NULL;
	RygelDataSink* _tmp20_ = NULL;
	RygelDataSource* _tmp21_ = NULL;
	RygelDataSource* _tmp22_ = NULL;
	GCancellable* _tmp23_ = NULL;
	GCancellable* _tmp24_ = NULL;
	SoupMessage* _tmp27_ = NULL;
	SoupMessageBody* _tmp28_ = NULL;
	SoupServer* _tmp29_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_val_if_fail (request_handler != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = request;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->server;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_set_server (self, _tmp1_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp2_ = request;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp3_ = ((RygelHTTPRequest*) _tmp2_)->msg;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->msg);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->msg = _tmp4_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp5_ = request_handler;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp6_ = rygel_http_get_handler_get_cancellable (_tmp5_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp7_ = _tmp6_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp7_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp8_ = request;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp9_ = _tmp8_->seek;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->seek);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->seek = _tmp10_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp11_ = request;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp12_ = _tmp11_->speed_request;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->speed);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->speed = _tmp13_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp14_ = src;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->priv->src);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->src = _tmp15_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp16_ = self->priv->src;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp17_ = self->priv->_server;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp18_ = self->msg;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp19_ = self->seek;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp20_ = rygel_data_sink_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->priv->sink);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->sink = _tmp20_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp21_ = self->priv->src;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_signal_connect_object (_tmp21_, "done", (GCallback) ___lambda6__rygel_data_source_done, self, 0);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp22_ = self->priv->src;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_signal_connect_object (_tmp22_, "error", (GCallback) ___lambda7__rygel_data_source_error, self, 0);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp23_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp24_ = _tmp23_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_tmp24_ != NULL) {
#line 494 "rygel-http-response.c"
		GCancellable* _tmp25_ = NULL;
		GCancellable* _tmp26_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp25_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp26_ = _tmp25_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_signal_connect_object (_tmp26_, "cancelled", (GCallback) _rygel_http_response_on_cancelled_g_cancellable_cancelled, self, 0);
#line 503 "rygel-http-response.c"
	}
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp27_ = self->msg;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp28_ = _tmp27_->response_body;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	soup_message_body_set_accumulate (_tmp28_, FALSE);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp29_ = self->priv->_server;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_object_weak_ref ((GObject*) _tmp29_, _rygel_http_response_on_server_weak_ref_gweak_notify, self);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->unref_soup_server = TRUE;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return self;
#line 519 "rygel-http-response.c"
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, request, request_handler, src, error);
#line 526 "rygel-http-response.c"
}


GeeList* rygel_http_response_preroll (RygelHTTPResponse* self, GError** error) {
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	RygelDataSource* _tmp1_ = NULL;
	RygelHTTPSeekRequest* _tmp2_ = NULL;
	RygelPlaySpeedRequest* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	GeeList* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp1_ = self->priv->src;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp2_ = self->seek;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp3_ = self->speed;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp4_ = rygel_data_source_preroll (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = _tmp4_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_propagate_error (error, _inner_error_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		return NULL;
#line 557 "rygel-http-response.c"
	}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp5_ = _tmp0_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	result = _tmp5_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (_tmp0_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return result;
#line 569 "rygel-http-response.c"
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* _data_;
	_data_ = _data;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (_data_->self);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_slice_free (RygelHttpResponseRunData, _data_);
#line 580 "rygel-http-response.c"
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	RygelHTTPResponse* _tmp0_ = NULL;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self = (RygelHTTPResponse*) base;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->self = _tmp0_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_real_run_co (_data_);
#line 602 "rygel-http-response.c"
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 610 "rygel-http-response.c"
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return result;
#line 619 "rygel-http-response.c"
}


static gboolean ___lambda8_ (RygelHTTPResponse* self) {
	gboolean result = FALSE;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	result = FALSE;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return result;
#line 631 "rygel-http-response.c"
}


static gboolean ____lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda8_ ((RygelHTTPResponse*) self);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return result;
#line 640 "rygel-http-response.c"
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	switch (_data_->_state_) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		case 0:
#line 649 "rygel-http-response.c"
		goto _state_0;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		case 1:
#line 653 "rygel-http-response.c"
		goto _state_1;
		default:
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_assert_not_reached ();
#line 658 "rygel-http-response.c"
	}
	_state_0:
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	(_data_->self->priv->run_continue_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->run_continue_target_destroy_notify (_data_->self->priv->run_continue_target), NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->self->priv->run_continue = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->self->priv->run_continue_target = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->self->priv->run_continue_target_destroy_notify = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->self->priv->run_continue = _rygel_http_response_real_run_co_gsource_func;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->self->priv->run_continue_target = _data_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->self->priv->run_continue_target_destroy_notify = NULL;
#line 675 "rygel-http-response.c"
	{
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_data_->_tmp0_ = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_data_->_tmp0_ = _data_->self->priv->src;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		rygel_data_source_start (_data_->_tmp0_, &_data_->_inner_error_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 685 "rygel-http-response.c"
			goto __catch50_g_error;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_data_->_inner_error_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda8__gsource_func, g_object_ref (_data_->self), g_object_unref);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_g_error_free0 (_data_->_error_);
#line 700 "rygel-http-response.c"
	}
	__finally50:
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_clear_error (&_data_->_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		return FALSE;
#line 711 "rygel-http-response.c"
	}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_data_->_state_ = 1;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return FALSE;
#line 717 "rygel-http-response.c"
	_state_1:
	;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_data_->_state_ == 0) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 724 "rygel-http-response.c"
	} else {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 728 "rygel-http-response.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_object_unref (_data_->_async_result);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return FALSE;
#line 734 "rygel-http-response.c"
}


static void rygel_http_response_real_end (RygelHTTPResponse* self, gboolean aborted, guint status) {
	RygelDataSource* _tmp0_ = NULL;
	SoupEncoding encoding = 0;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	SoupEncoding _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GSourceFunc _tmp11_ = NULL;
	void* _tmp11__target = NULL;
	guint _tmp13_ = 0U;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = self->priv->src;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_data_source_stop (_tmp0_);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp1_ = self->msg;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp2_ = _tmp1_->response_headers;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp3_ = soup_message_headers_get_encoding (_tmp2_);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	encoding = _tmp3_;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp5_ = aborted;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (!_tmp5_) {
#line 765 "rygel-http-response.c"
		SoupEncoding _tmp6_ = 0;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp6_ = encoding;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp4_ = _tmp6_ != SOUP_ENCODING_CONTENT_LENGTH;
#line 771 "rygel-http-response.c"
	} else {
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp4_ = FALSE;
#line 775 "rygel-http-response.c"
	}
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_tmp4_) {
#line 779 "rygel-http-response.c"
		SoupMessage* _tmp7_ = NULL;
		SoupMessageBody* _tmp8_ = NULL;
		SoupServer* _tmp9_ = NULL;
		SoupMessage* _tmp10_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp7_ = self->msg;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp8_ = _tmp7_->response_body;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		soup_message_body_complete (_tmp8_);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp9_ = self->priv->_server;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp10_ = self->msg;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		soup_server_unpause_message (_tmp9_, _tmp10_);
#line 796 "rygel-http-response.c"
	}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp11_ = self->priv->run_continue;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp11__target = self->priv->run_continue_target;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_tmp11_ != NULL) {
#line 804 "rygel-http-response.c"
		GSourceFunc _tmp12_ = NULL;
		void* _tmp12__target = NULL;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp12_ = self->priv->run_continue;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp12__target = self->priv->run_continue_target;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp12_ (_tmp12__target);
#line 813 "rygel-http-response.c"
	}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp13_ = status;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_tmp13_ != ((guint) SOUP_STATUS_NONE)) {
#line 819 "rygel-http-response.c"
		SoupMessage* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp14_ = self->msg;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp15_ = status;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		soup_message_set_status (_tmp14_, _tmp15_);
#line 828 "rygel-http-response.c"
	}
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 832 "rygel-http-response.c"
}


void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status) {
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_if_fail (self != NULL);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	RYGEL_HTTP_RESPONSE_GET_CLASS (self)->end (self, aborted, status);
#line 841 "rygel-http-response.c"
}


static void rygel_http_response_on_cancelled (RygelHTTPResponse* self, GCancellable* cancellable) {
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_if_fail (self != NULL);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_if_fail (cancellable != NULL);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_end (self, TRUE, (guint) SOUP_STATUS_CANCELLED);
#line 852 "rygel-http-response.c"
}


static void rygel_http_response_on_server_weak_ref (RygelHTTPResponse* self, GObject* object) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_if_fail (object != NULL);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->unref_soup_server = FALSE;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp1_ = _tmp0_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_cancellable_cancel (_tmp1_);
#line 871 "rygel-http-response.c"
}


SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self) {
	SoupServer* result;
	SoupServer* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = self->priv->_server;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	result = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return result;
#line 886 "rygel-http-response.c"
}


static void rygel_http_response_set_server (RygelHTTPResponse* self, SoupServer* value) {
	SoupServer* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_if_fail (self != NULL);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = value;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->_server = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_object_notify ((GObject *) self, "server");
#line 900 "rygel-http-response.c"
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	GCancellable* _tmp0_ = NULL;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self = (RygelHTTPResponse*) base;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = self->priv->_cancellable;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	result = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return result;
#line 916 "rygel-http-response.c"
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self = (RygelHTTPResponse*) base;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = value;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->_cancellable = _tmp1_;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 936 "rygel-http-response.c"
}


gint rygel_http_response_get_priority (RygelHTTPResponse* self) {
	gint result;
	gint _tmp0_ = 0;
	gchar* mode = NULL;
	SoupMessage* _tmp2_ = NULL;
	SoupMessageHeaders* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gint _tmp11_ = 0;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = self->priv->_priority;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_tmp0_ != (-1)) {
#line 957 "rygel-http-response.c"
		gint _tmp1_ = 0;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp1_ = self->priv->_priority;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		result = _tmp1_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		return result;
#line 965 "rygel-http-response.c"
	}
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp2_ = self->msg;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp3_ = _tmp2_->request_headers;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp4_ = soup_message_headers_get_one (_tmp3_, "transferMode.dlna.org");
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	mode = _tmp5_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp7_ = mode;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_tmp7_ == NULL) {
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp6_ = TRUE;
#line 983 "rygel-http-response.c"
	} else {
		const gchar* _tmp8_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp8_ = mode;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp6_ = g_strcmp0 (_tmp8_, "Interactive") == 0;
#line 990 "rygel-http-response.c"
	}
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_tmp6_) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		self->priv->_priority = G_PRIORITY_DEFAULT;
#line 996 "rygel-http-response.c"
	} else {
		const gchar* _tmp9_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp9_ = mode;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		if (g_strcmp0 (_tmp9_, "Streaming") == 0) {
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
			self->priv->_priority = G_PRIORITY_HIGH;
#line 1005 "rygel-http-response.c"
		} else {
			const gchar* _tmp10_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
			_tmp10_ = mode;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
			if (g_strcmp0 (_tmp10_, "Background") == 0) {
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
				self->priv->_priority = G_PRIORITY_LOW;
#line 1014 "rygel-http-response.c"
			} else {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
				self->priv->_priority = G_PRIORITY_DEFAULT;
#line 1018 "rygel-http-response.c"
			}
		}
	}
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp11_ = self->priv->_priority;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	result = _tmp11_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_free0 (mode);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	return result;
#line 1030 "rygel-http-response.c"
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	((RygelHTTPResponseClass *) klass)->end = rygel_http_response_real_end;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_SERVER, g_param_spec_object ("server", "server", "server", soup_server_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_PRIORITY, g_param_spec_int ("priority", "priority", "priority", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1053 "rygel-http-response.c"
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	iface->run_finish = rygel_http_response_real_run_finish;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
#line 1068 "rygel-http-response.c"
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->_priority = -1;
#line 1077 "rygel-http-response.c"
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
	gboolean _tmp0_ = FALSE;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_tmp0_ = self->priv->unref_soup_server;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	if (_tmp0_) {
#line 1090 "rygel-http-response.c"
		SoupServer* _tmp1_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		_tmp1_ = self->priv->_server;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_object_weak_unref ((GObject*) _tmp1_, _rygel_http_response_on_server_weak_ref_gweak_notify, self);
#line 1096 "rygel-http-response.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->msg);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->seek);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->speed);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	(self->priv->run_continue_target_destroy_notify == NULL) ? NULL : (self->priv->run_continue_target_destroy_notify (self->priv->run_continue_target), NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->run_continue = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->run_continue_target = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	self->priv->run_continue_target_destroy_notify = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->priv->src);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	_g_object_unref0 (self->priv->sink);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
#line 1120 "rygel-http-response.c"
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	switch (property_id) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		case RYGEL_HTTP_RESPONSE_SERVER:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_value_set_object (value, rygel_http_response_get_server (self));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		case RYGEL_HTTP_RESPONSE_PRIORITY:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		g_value_set_int (value, rygel_http_response_get_priority (self));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		break;
#line 1161 "rygel-http-response.c"
		default:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		break;
#line 1167 "rygel-http-response.c"
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
	switch (property_id) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		case RYGEL_HTTP_RESPONSE_SERVER:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		rygel_http_response_set_server (self, g_value_get_object (value));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		break;
#line 1189 "rygel-http-response.c"
		default:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-response.vala"
		break;
#line 1195 "rygel-http-response.c"
	}
}



