/* rygel-media-player.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Sivakumar Mani <siva@orexel.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
};

struct _Block1Data {
	int _ref_count_;
	RygelMediaPlayer* self;
	GUPnPDIDLLiteObject* item;
};



GType rygel_media_player_get_type (void) G_GNUC_CONST;
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time);
gboolean rygel_media_player_seek_bytes (RygelMediaPlayer* self, gint64 bytes);
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
gdouble rygel_media_player_play_speed_to_double (RygelMediaPlayer* self, const gchar* speed);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self);
void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
gdouble rygel_media_player_get_volume (RygelMediaPlayer* self);
void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value);
gint64 rygel_media_player_get_duration (RygelMediaPlayer* self);
gint64 rygel_media_player_get_size (RygelMediaPlayer* self);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_mime_type (RygelMediaPlayer* self);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gboolean rygel_media_player_get_can_seek_bytes (RygelMediaPlayer* self);
gchar* rygel_media_player_get_content_features (RygelMediaPlayer* self);
void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_time_utils_time_to_string (gint64 time);
gint64 rygel_media_player_get_position (RygelMediaPlayer* self);
gint64 rygel_media_player_get_byte_position (RygelMediaPlayer* self);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
gchar* rygel_media_player_get_protocol_info (RygelMediaPlayer* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _rygel_media_player_protocol_info___lambda4_ (Block1Data* _data1_, GUPnPDIDLLiteItem* object);
static void __rygel_media_player_protocol_info___lambda4__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * Seek to a point in the current media that is
     * this many microseconds after the start.
     */
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time) {
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->seek (self, time);
#line 145 "rygel-media-player.c"
}


/**
     * Seek to a byte position in the current media.
     */
gboolean rygel_media_player_seek_bytes (RygelMediaPlayer* self, gint64 bytes) {
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->seek_bytes (self, bytes);
#line 157 "rygel-media-player.c"
}


/**
     * Return the protocols supported by this renderer,
     * such as "http-get" and "rtsp".
     */
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1) {
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_protocols (self, result_length1);
#line 170 "rygel-media-player.c"
}


gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1) {
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_mime_types (self, result_length1);
#line 179 "rygel-media-player.c"
}


/**
     * Transform a fractional playspeed (e.g. "-1/4") to double.
     * Input values are expected to be valid rational numbers.
     */
static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 789 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 201 "rygel-media-player.c"
}


gdouble rygel_media_player_play_speed_to_double (RygelMediaPlayer* self, const gchar* speed) {
	gdouble result = 0.0;
	gchar** rational = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint rational_length1 = 0;
	gint _rational_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (speed != NULL, 0.0);
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp0_ = speed;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "/", 2);
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	rational = _tmp2_;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	rational_length1 = _vala_array_length (_tmp1_);
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_rational_size_ = rational_length1;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp3_ = rational;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp3__length1 = rational_length1;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp4_ = _tmp3_[0];
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_vala_assert (g_strcmp0 (_tmp4_, "0") != 0, "rational[0] != \"0\"");
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp5_ = rational;
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp5__length1 = rational_length1;
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp6_ = _tmp5_[1];
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	if (_tmp6_ == NULL) {
#line 258 "rygel-media-player.c"
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp7_ = rational;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp7__length1 = rational_length1;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp8_ = _tmp7_[0];
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp9_ = double_parse (_tmp8_);
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		result = _tmp9_;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		rational = (_vala_array_free (rational, rational_length1, (GDestroyNotify) g_free), NULL);
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		return result;
#line 277 "rygel-media-player.c"
	}
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp10_ = rational;
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp10__length1 = rational_length1;
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp11_ = _tmp10_[1];
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_vala_assert (g_strcmp0 (_tmp11_, "0") != 0, "rational[1] != \"0\"");
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp12_ = rational;
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp12__length1 = rational_length1;
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp13_ = _tmp12_[0];
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp14_ = double_parse (_tmp13_);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp15_ = rational;
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp15__length1 = rational_length1;
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp16_ = _tmp15_[1];
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp17_ = double_parse (_tmp16_);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	result = _tmp14_ / _tmp17_;
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	rational = (_vala_array_free (rational, rational_length1, (GDestroyNotify) g_free), NULL);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return result;
#line 309 "rygel-media-player.c"
}


gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self) {
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_playback_state (self);
#line 318 "rygel-media-player.c"
}


void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value) {
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_playback_state (self, value);
#line 327 "rygel-media-player.c"
}


gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1) {
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_allowed_playback_speeds (self, result_length1);
#line 336 "rygel-media-player.c"
}


gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self) {
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_playback_speed (self);
#line 345 "rygel-media-player.c"
}


void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value) {
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_playback_speed (self, value);
#line 354 "rygel-media-player.c"
}


gchar* rygel_media_player_get_uri (RygelMediaPlayer* self) {
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_uri (self);
#line 363 "rygel-media-player.c"
}


void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value) {
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_uri (self, value);
#line 372 "rygel-media-player.c"
}


gdouble rygel_media_player_get_volume (RygelMediaPlayer* self) {
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_volume (self);
#line 381 "rygel-media-player.c"
}


void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value) {
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_volume (self, value);
#line 390 "rygel-media-player.c"
}


gint64 rygel_media_player_get_duration (RygelMediaPlayer* self) {
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_duration (self);
#line 399 "rygel-media-player.c"
}


gint64 rygel_media_player_get_size (RygelMediaPlayer* self) {
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_size (self);
#line 408 "rygel-media-player.c"
}


gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self) {
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_metadata (self);
#line 417 "rygel-media-player.c"
}


void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value) {
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_metadata (self, value);
#line 426 "rygel-media-player.c"
}


gchar* rygel_media_player_get_mime_type (RygelMediaPlayer* self) {
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_mime_type (self);
#line 435 "rygel-media-player.c"
}


void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value) {
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_mime_type (self, value);
#line 444 "rygel-media-player.c"
}


gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self) {
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_can_seek (self);
#line 453 "rygel-media-player.c"
}


gboolean rygel_media_player_get_can_seek_bytes (RygelMediaPlayer* self) {
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_can_seek_bytes (self);
#line 462 "rygel-media-player.c"
}


gchar* rygel_media_player_get_content_features (RygelMediaPlayer* self) {
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_content_features (self);
#line 471 "rygel-media-player.c"
}


void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value) {
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_content_features (self, value);
#line 480 "rygel-media-player.c"
}


gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self) {
	gchar* result;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp0_ = rygel_media_player_get_duration (self);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp1_ = _tmp0_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp2_ = rygel_time_utils_time_to_string (_tmp1_);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	result = _tmp2_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return result;
#line 501 "rygel-media-player.c"
}


gint64 rygel_media_player_get_position (RygelMediaPlayer* self) {
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_position (self);
#line 510 "rygel-media-player.c"
}


gint64 rygel_media_player_get_byte_position (RygelMediaPlayer* self) {
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 94 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_byte_position (self);
#line 519 "rygel-media-player.c"
}


gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self) {
	gchar* result;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp0_ = rygel_media_player_get_position (self);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp1_ = _tmp0_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp2_ = rygel_time_utils_time_to_string (_tmp1_);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	result = _tmp2_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return result;
#line 540 "rygel-media-player.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return _data1_;
#line 549 "rygel-media-player.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 558 "rygel-media-player.c"
		RygelMediaPlayer* self;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		self = _data1_->self;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_g_object_unref0 (_data1_->item);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_g_object_unref0 (self);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_slice_free (Block1Data, _data1_);
#line 568 "rygel-media-player.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 576 "rygel-media-player.c"
}


static void _rygel_media_player_protocol_info___lambda4_ (Block1Data* _data1_, GUPnPDIDLLiteItem* object) {
	RygelMediaPlayer* self;
	GUPnPDIDLLiteItem* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	self = _data1_->self;
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_if_fail (object != NULL);
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp0_ = object;
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp1_ = _g_object_ref0 ((GUPnPDIDLLiteObject*) _tmp0_);
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_g_object_unref0 (_data1_->item);
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_data1_->item = _tmp1_;
#line 596 "rygel-media-player.c"
}


static void __rygel_media_player_protocol_info___lambda4__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_rygel_media_player_protocol_info___lambda4_ (self, item);
#line 603 "rygel-media-player.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 610 "rygel-media-player.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_list_free (self);
#line 619 "rygel-media-player.c"
}


gchar* rygel_media_player_get_protocol_info (RygelMediaPlayer* self) {
	gchar* result;
	Block1Data* _data1_;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GUPnPDIDLLiteParser* p = NULL;
	GUPnPDIDLLiteParser* _tmp9_ = NULL;
	GUPnPDIDLLiteParser* _tmp10_ = NULL;
	GList* resources = NULL;
	GUPnPDIDLLiteObject* _tmp16_ = NULL;
	GList* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	gchar* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_data1_->_ref_count_ = 1;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_data1_->self = g_object_ref (self);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp1_ = rygel_media_player_get_metadata (self);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp2_ = _tmp1_;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp3_ = _tmp2_;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp4_ = _tmp3_ == NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_g_free0 (_tmp3_);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	if (_tmp4_) {
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp0_ = TRUE;
#line 662 "rygel-media-player.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp5_ = rygel_media_player_get_uri (self);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp6_ = _tmp5_;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp7_ = _tmp6_;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp0_ = _tmp7_ == NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_g_free0 (_tmp7_);
#line 677 "rygel-media-player.c"
	}
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	if (_tmp0_) {
#line 681 "rygel-media-player.c"
		gchar* _tmp8_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp8_ = g_strdup ("");
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		result = _tmp8_;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		block1_data_unref (_data1_);
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_data1_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		return result;
#line 693 "rygel-media-player.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp9_ = gupnp_didl_lite_parser_new ();
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	p = _tmp9_;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_data1_->item = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp10_ = p;
#line 154 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	g_signal_connect_data (_tmp10_, "item-available", (GCallback) __rygel_media_player_protocol_info___lambda4__gupnp_didl_lite_parser_item_available, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 705 "rygel-media-player.c"
	{
		GUPnPDIDLLiteParser* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp11_ = p;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp12_ = rygel_media_player_get_metadata (self);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp13_ = _tmp12_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp14_ = _tmp13_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		gupnp_didl_lite_parser_parse_didl (_tmp11_, _tmp14_, &_inner_error_);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_g_free0 (_tmp14_);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 725 "rygel-media-player.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp15_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_error_ = _inner_error_;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_inner_error_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_tmp15_ = g_strdup ("");
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		result = _tmp15_;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_g_error_free0 (_error_);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_g_object_unref0 (p);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		block1_data_unref (_data1_);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_data1_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		return result;
#line 752 "rygel-media-player.c"
	}
	__finally0:
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_g_object_unref0 (p);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		block1_data_unref (_data1_);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		_data1_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		return NULL;
#line 769 "rygel-media-player.c"
	}
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp16_ = _data1_->item;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp17_ = gupnp_didl_lite_object_get_resources (_tmp16_);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	resources = _tmp17_;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp18_ = resources;
#line 779 "rygel-media-player.c"
	{
		GList* resource_collection = NULL;
		GList* resource_it = NULL;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		resource_collection = _tmp18_;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
#line 787 "rygel-media-player.c"
			GUPnPDIDLLiteResource* _tmp19_ = NULL;
			GUPnPDIDLLiteResource* resource = NULL;
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
			_tmp19_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
			resource = _tmp19_;
#line 794 "rygel-media-player.c"
			{
				GUPnPDIDLLiteResource* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_tmp20_ = resource;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_tmp21_ = gupnp_didl_lite_resource_get_uri (_tmp20_);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_tmp22_ = _tmp21_;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_tmp23_ = rygel_media_player_get_uri (self);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_tmp24_ = _tmp23_;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_tmp25_ = _tmp24_;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_tmp26_ = g_strcmp0 (_tmp22_, _tmp25_) == 0;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_g_free0 (_tmp25_);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				if (_tmp26_) {
#line 821 "rygel-media-player.c"
					GUPnPDIDLLiteResource* _tmp27_ = NULL;
					GUPnPProtocolInfo* _tmp28_ = NULL;
					GUPnPProtocolInfo* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					_tmp27_ = resource;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					_tmp28_ = gupnp_didl_lite_resource_get_protocol_info (_tmp27_);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					_tmp29_ = _tmp28_;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					_tmp30_ = gupnp_protocol_info_to_string (_tmp29_);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					result = _tmp30_;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					_g_object_unref0 (resource);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					__g_list_free__g_object_unref0_0 (resources);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					_g_object_unref0 (p);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					block1_data_unref (_data1_);
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					_data1_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
					return result;
#line 848 "rygel-media-player.c"
				}
#line 162 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
				_g_object_unref0 (resource);
#line 852 "rygel-media-player.c"
			}
		}
	}
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_tmp31_ = g_strdup ("");
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	result = _tmp31_;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	__g_list_free__g_object_unref0_0 (resources);
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_g_object_unref0 (p);
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	block1_data_unref (_data1_);
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	_data1_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	return result;
#line 870 "rygel-media-player.c"
}


static void rygel_media_player_base_init (RygelMediaPlayerIface * iface) {
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	static gboolean initialized = FALSE;
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
	if (!initialized) {
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		initialized = TRUE;
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 895 "rygel-media-player.c"
		/**
		     * A DIDLLite document describing the current media URI or null.
		     * The document is either the one received from a UPnP control point or
		     * one generated by the implementing class.
		     */
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("can-seek-bytes", "can-seek-bytes", "can-seek-bytes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 909 "rygel-media-player.c"
		/**
		     * The contents of the contentFeatures.dlna.org HTTP header,
		     * containing the 4th field of the protocol info for the current
		     * media URI. Or null if the header does not exist or the media
		     * does not have DLNA information attached.
		     */
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 34 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-player.vala"
		g_object_interface_install_property (iface, g_param_spec_int64 ("byte-position", "byte-position", "byte-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 922 "rygel-media-player.c"
	}
}


/**
 * This interface maps UPnP AVTransport:2 methods to the plugin's specific implementation.
 *
 * This interface is useful only when implementing Rygel renderer plugins.
 * Instances of this interface are retrieved from
 * rygel_media_renderer_plugin_get_player().
 */
GType rygel_media_player_get_type (void) {
	static volatile gsize rygel_media_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaPlayerIface), (GBaseInitFunc) rygel_media_player_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_media_player_type_id;
		rygel_media_player_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelMediaPlayer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_media_player_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&rygel_media_player_type_id__volatile, rygel_media_player_type_id);
	}
	return rygel_media_player_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



