/* example.i: A simple example for the Q SWIG interface. -*-c-*- */

// Compile as follows:
// 1. swig -q example.i
// 2. qcc example.c example_wrap.c

/* The module header. Note that this also sets the name of the generated Q
   stubs module, thus you should name the qcc output file accordingly. */

%module example

/* Some extra C code to be included in the generated C module. */

%{
#include <stdio.h>
%}

/* The functions and variables exported by example.c, which this module
   makes available. After running SWIG, take a look at the generated Q module
   example.q to see how these are wrapped. In particular, you will notice that
   SWIG generates a pair of get and set functions for each declared
   variable. */

/* Note that capitalized function identifiers will be stropped with a leading
   underscore, to be compatible with Q's function naming rules. Thus, e.g.,
   the wrapper functions for the Foo variable below would actually be named
   _Foo_get and _Foo_set. If we don't want this then we must do an explicit
   %rename instead, as illustrated below. */

extern int gcd(int x, int y);
%rename(foo) Foo;
extern double Foo;

/* The following stuff uses SWIG-Q specific extensions, so we enclose it
   in an appropriate #ifdef. */

#ifdef SWIGQ

/* Some extra Q code to be included in the generated Q module. */

%stubs %{
/* Run me to test the interface. */
test	= printf "The gcd of %d and %d is %d\n" (42,105,gcd 42 105) ||
	  printf "Foo = %g\n" foo_get ||
	  foo_set 3.1415926 ||
	  printf "Foo = %g\n" foo_get;
%}

/* Sample initialization code. This C code will be executed when the module is
   loaded by the Q interpreter. */

%init %{
  printf("Greetings from the example module!\n");
%}

/* Sample finalization code. This C code will be executed when the module is
   unloaded by the Q interpreter. */

%fini %{
  printf("Bye.\n");
%}

#endif
