#!/bin/sh

# Example showing how to embed a Q program in a shell script. See Appendix B.4
# in the manual.

# Note that we pass the real script name as ARGS!1 here (and the number
# parameter as ARGS!2), so that we can give proper diagnostics.

q - "$0" "$1" -c 'main (val (ARGS!2))' <<EOF

fib N		= A where (A,B) = fibs N;
fibs N		= (B,A+B) where (A,B) = fibs (N-1) if N>0;
		= (0,1) otherwise;

main N:Int	= do (printf "%s\n".str) $ map fib [0..N] || exit 0;
main _		= printf "Usage: %s <number>\n" (ARGS!1) || exit 1
		    otherwise;

EOF
