" Vim syntax file
" Language:    Q
" Maintainers: Albert Graef <Dr.Graef@t-online.de>
" Last Change: 2007 Jul 5
" URL:	       http://q-lang.sf.net

" This was mostly pilfered from vim's Prolog mode by Thomas Koehler.
" Only basic highlighting of comments, numbers, strings and variable
" symbols is supported right now.

" To install, copy this file to ~/.vim/syntax and add the following
" entry to the ~/.vim/filetype.vim file so that Vim recognizes the
" '.q' file type:
" augroup filetypedetect
" au BufNewFile,BufRead *.q	setf q
" augroup END

" Quit when a syntax file was already loaded
if version < 600
   syntax clear
elseif exists("b:current_syntax")
  finish
endif

" Q is case sensitive.
syn case match

" comments and strings

syn region   qCComment	start=+/\*+ end=+\*/+
syn match    qComment	+//.*+
syn region   qString	start=+"+ skip=+\\"+ end=+"+

" keywords
syn keyword qKeyword	as and const def div else extern from
syn keyword qKeyword	if import in include mod not or otherwise
syn keyword qKeyword	private public special then type undef
syn keyword qKeyword	var virtual where

syn match   qNumber	      "\<[0-9]*\>"
syn match   qHexNumber	      "\<0[Xx][0-9A-Fa-f]*\>"
syn match   qIdentifier       "\<[A-Z][A-Za-z0-9_]*\>"
syn match   qCommentError     "\*/"
syn match   qSpecialCharacter ";"
syn match   qSpecialCharacter "::"

" synchronization; you might have to fiddle with this
syn sync minlines=50
syn sync maxlines=500

" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_q_syn_inits")
  if version < 508
    let did_q_syn_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink qComment		Comment
  HiLink qCComment		Comment
  HiLink qCharCode		Special

  HiLink qKeyword		Keyword
  HiLink qSpecialCharacter	Special
  HiLink qNumber		Number
  HiLink qHexNumber		Number
  HiLink qIdentifier		Identifier
  HiLink qCommentError		Error
  HiLink qString		String

  delcommand HiLink
endif

let b:current_syntax = "q"

" vim: ts=8
