#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "mgwtypes.h"
#include "utils.h"

/* Entry point */
guchar
limit_byte_range (gint v)
{
  guchar u;

  if (v > 255)
    u = 255;
  else if (v < 0)
    u = 0;
  else
    u = (guchar) v;

  return u;
}

void
get_size_info (MgwSizeInfo *size_info, GdkPixbuf *pbuf)
{
  size_info->w  = gdk_pixbuf_get_width (pbuf);
  size_info->h  = gdk_pixbuf_get_height (pbuf);
  size_info->rs = gdk_pixbuf_get_rowstride (pbuf);
  size_info->nc = gdk_pixbuf_get_n_channels (pbuf);
}

void
restore_rgb_data (GdkPixbuf *pbuf, guchar *data, MgwSizeInfo si)
{
  gint i, j, k;
  guchar *p0 = gdk_pixbuf_get_pixels (pbuf);

  for (i = 0; i < si.h; i++) {
    for (j = 0; j < si.w; j++) {
      for (k = 0; k < 3; k++) {
	*(p0 + i * si.rs + j * si.nc + k) = data[(i * si.w + j) * 3 + k];
      }
    }
  }
}

guchar *
stock_rgb_data (GdkPixbuf *pbuf, MgwSizeInfo si)
{
  gint i, j, k;
  guchar *data, *p0;

  data = (guchar *) g_malloc (sizeof (guchar) * si.w * si.h * 3);

  if (!data) {
    g_warning ("stock_rgb_data(utils.c): memory allocation failed");
    return NULL;
  }

  p0 = gdk_pixbuf_get_pixels (pbuf);

  for (i = 0; i < si.h; i++)
    for (j = 0; j < si.w; j++)
      for (k = 0; k < 3; k++)
	data[(i * si.w + j) * 3 + k] = *(p0 + i * si.rs + j * si.nc + k);

  return data;
}

void
swap (gint *a, gint *b)
{
  gint tmp;

  tmp = *a;
  *a = *b;
  *b = tmp;
}

GtkWidget *
show_error_dialog (GtkWindow *parent, gchar *msg)
{
  GtkWidget *dialog;

  if (parent == NULL)
    parent = GTK_WINDOW (get_app ());

  dialog = gtk_message_dialog_new (parent,
				   GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR,
				   GTK_BUTTONS_OK, "%s", msg);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

GtkWidget *
show_message_dialog (GtkWindow *parent, gchar *msg)
{
  GtkWidget *dialog;

  if (parent == NULL)
    parent = GTK_WINDOW (get_app ());

  dialog = gtk_message_dialog_new (parent,
				   GTK_DIALOG_MODAL, GTK_MESSAGE_INFO,
				   GTK_BUTTONS_OK, "%s", msg);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}
