#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "mgwtypes.h"
#include "bat.h"
#include "interface.h"
#include "image.h"
#include "filters.h"
#include "arrange.h"

static void
alice (GdkPixbuf *pbuf)
{
  filter_exec  (NULL, "Recursive Paint");           show_progress (0.50, pbuf);
  filter_exec  (NULL, "Impulse");                   show_progress (0.75, pbuf);
  filter_exec  (NULL, "Autumn Leaves");             show_progress (1.00, pbuf);
}

static void
becky (GdkPixbuf *pbuf)
{
  filter_exec (NULL, "Impulse");                    show_progress (0.50, pbuf);
  filter_exec (NULL, "Monotonic");                  show_progress (0.70, pbuf);
  filter_exec (NULL, "Autumn Leaves");              show_progress (0.90, pbuf);
  filter_exec (NULL, "Pow-Contrast-On");            show_progress (1.00, pbuf);
}

static void
elly (GdkPixbuf *pbuf)
{
  filter_exec (NULL, "Sketch");                     show_progress (0.60, pbuf);
  filter_exec (NULL, "Impulse");                    show_progress (0.80, pbuf);
  filter_exec (NULL, "Autumn Leaves");              show_progress (1.00, pbuf);
}

static void
flora (GdkPixbuf *pbuf)
{
  filter_exec (NULL, "Sketch");                     show_progress (0.50, pbuf);
  filter_exec (NULL, "Pale");                       show_progress (0.60, pbuf);
  filter_exec (NULL, "Pow-Brightness-Off");         show_progress (0.70, pbuf);
  filter_exec (NULL, "Pow-Brightness-Off");         show_progress (0.80, pbuf);
  filter_exec (NULL, "Pow-Contrast-On");            show_progress (0.90, pbuf);
  filter_exec (NULL, "Recursive Paint");            show_progress (0.95, pbuf);
  filter_exec (NULL, "Autumn Leaves");              show_progress (1.00, pbuf);
}

/* Entry point */
void
bat_exec (GtkWidget *dummy, gchar *name)
{
  GdkPixbuf *pbuf = get_pbuf ();
  gchar buff[64];
  gboolean fail = FALSE;

  switch (name[0]) {
  case 'A':
    if (!strcmp (name, "Alice"))
      alice (pbuf);
    else
      fail = TRUE;
    break;
    
  case 'B':
    if (!strcmp (name, "Becky"))
      becky (pbuf);
    else
      fail = TRUE;
    break;
    
  case 'E':
    if (!strcmp (name, "Elly"))
      elly (pbuf);
    else
      fail = TRUE;
    break;
    
  case 'F':
    if (!strcmp (name, "Flora"))
      flora (pbuf);
    else
      fail = TRUE;
    break;
    
  default:
    fail = TRUE;
  }

  if (fail) {
    g_warning ("bat_exec: FALIED(Internal error): %s", name);
    sprintf (buff, "%s: FAILED(Internal error)", name);
    put_string_to_appbar (buff);
  }

  show_progress (0, pbuf);
  sprintf (buff, "%s: DONE", name);
  put_string_to_appbar (buff);
}
