/* xnet.h for kan netmaj */
#define VERSION "KAN NetMaj Version 1.0.6" 

#define BUTTON 1
#define SELBOX 2
#define TEXTBOX 3
#define MENUBUTTON 4

#define XBM    1
#define XPM    2
#define TEXT   3

#define HORIZ 0
#define VERT  1

#define SEL_TIE 21
#define SEL_PON 22
#define SEL_KAN 23
#define SEL_RON 24
#define SEL_CANCEL 25
#define SEL_REACH 30
#define SEL_KAN2 31
#define SEL_TUMO 32
#define SEL_NONE 35

#define BGFNT 0
#define SLFNT 1
#define NFNT 2
#define FFNT 3

#define MASK ( ExposureMask | ButtonPressMask | ButtonReleaseMask | VisibilityChangeMask | KeyPressMask | SelectionNotify)

#include "../pai.h"
#include "../global.h"
#include "../result.h"

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/xpm.h>

#define nmax(a, b) (( (a) > (b) ) ? (a) : (b) )

struct colors_set {
  Pixel plus, minus, title, num;
  Pixel frame1, frame2;
  Pixel pai, darkpai1, darkpai2, darkpai3;
  Pixel rev1, rev2, rev3, rev4, rev5;
  Pixel btntx, dlgtx, nametx, kazetx, board, mess;
};

struct object {
  int x, y, wth, hgt, dt;
};

#include "config.h"


#ifndef GLOBAL_VARIABLE
#define GLOBAL_VARIABLE 1
/* color set */
struct colors_set cols;

/* windows */
int main_win,    /* main window */
    help_win,    /* help window */
    dlg1,        /* dialog for reach, kan and tumo */
    dlg2,        /* dialog for tie, pon, kan, ron */
    dlg3,        /* dialog for choice of tie or kan */
    msg1,        /* message window for declaration */
    msg2,        /* message window for connection */
    msg3,        /* window for showing some information */
    msg4,        /* window for advice */
    menu,        /* menu window */
    talk_win,    /* talk window */
    msg5;        /* comment window */

/* some items */
int main_but,    /* button for opening menu */
    menu_but,    /* some buttons in menu */
    pai_sel,     /* selection box for hand pai */
    help_but,    /* help buttons */
    dlg1_but,    /* reach, kan and tumo buttons */
    dlg2_but,    /* tie, pon, kan, ron and cancel buttons */
    dlg3_but,    /* cancel button */
    naki_sel,    /* selection box for choice of tie or kan */
    adv_but,     /* button for advice */
    result_but,  /* buttons in result */
    talk_but1,   /* buttons in talk window */
    talk_but2,   /* buttons in talk window */
    talk_txt;    /* text box in talk window */

/* size information of pai */
int pwsize,      /* width of pai surface */
    phsize,      /* height of pai surface */
    ftwsize,     /* width of tate pai */
    fthsize,     /* height of tate pai */
    fywsize,     /* width of yoko pai */
    fyhsize;     /* height of yoko pai */
#else
extern struct colors_set cols;
extern int main_win, help_win, dlg1, dlg2, dlg3, msg1, msg2, msg3, msg4, menu;
extern int talk_win, msg5;
extern int main_but, menu_but, pai_sel, help_but;
extern int dlg1_but, dlg2_but, dlg3_but, naki_sel;
extern int result_but, adv_but;
extern int talk_but1, talk_but2, talk_txt;
extern int pwsize, phsize, ftwsize, fthsize, fywsize, fyhsize;
#endif
