/* init.c for kan netmaj */
#include "xnet.h"

char *colstr[7];
extern char *fontstr[6];
extern Display *display;
extern int play_speed;

/* default fonts */
static char *fstr[] = {
  BIGFONT, 
  SMALLFONT, 
  NUMFONT, 
  FIXEDFONT, 
  JBIGFONT, 
  JSMALLFONT,
};

/* default color */
static char *colss[] = {
  REVCOL, 
  DLGTXCOL, 
  BTNTXCOL, 
  NAMETXCOL, 
  KAZETXCOL, 
  BOARDCOL, 
  MESSAGECOL,
};

/* some resources */
static struct resource {
  char *name;
  char *class;
  int id;
} rsc[]  = {
  {"knetmaj.bigfont", "Knetmaj.Bigfont", 0}, 
  {"knetmaj.smallfont", "Knetmaj.Smallfont", 1},
  {"knetmaj.numfont", "Knetmaj.Numfont", 2},
  {"knetmaj.fixedfont", "Knetmaj.Fixedfont", 3},
  {"knetmaj.jbigfont", "Knetmaj.Jbigfont", 4},
  {"knetmaj.jsmallfont", "Knetmaj.Jsmallfont", 5},
  {"knetmaj.reversecol", "Knetmaj.Reversecol", 6},
  {"knetmaj.dlgtextcol", "Knetmaj.Dlgtextcol", 7},
  {"knetmaj.btntextcol", "Knetmaj.Btntextcol", 8},
  {"knetmaj.nametextcol", "Knetmaj.Nametextcol", 9},
  {"knetmaj.kazetextcol", "Knetmaj.Kazetextcol", 10},
  {"knetmaj.boardcol", "Knetmaj.Boardcol", 11},
  {"knetmaj.messagecol", "Knetmaj.Messagecol", 12},
  {"knetmaj.playspeed", "Knetmaj.Playspeed", 13},
  {NULL, NULL, -1},
};

XrmDatabase rDB;

/* initialize some resource parameters */
void
initialize()
{
  int i;
  char name[1024], str[BUFSIZ];
  char *classname = "Knetmaj";
  char *env, *str_type[20], *sp;
  XrmDatabase appDB, appresDB, svDB, hmDB;
  struct resource *rp;

  XrmValue value;

  XrmInitialize();

  strcpy(name, APPDEFPTH);
  strcat(name, classname);
  appDB = XrmGetFileDatabase(name);
  XrmMergeDatabases(appDB, &rDB);

  if (getenv("XUSERFILESEARCHPATH") != NULL) {
    strcpy(str, getenv("XUSERFILESEARCHPATH"));
    sp = strtok(str, ":");
    while(sp != NULL) {
      sprintf(name, "%s/%s", sp, classname);
      if ((appresDB = XrmGetFileDatabase(name)) != NULL)
	break;
      sp = strtok(NULL, ":");
    }
  }
  else if (getenv("XAPPLRESDIR") != NULL) {
    strcpy(str, getenv("XAPPLRESDIR"));
    sp = strtok(str, ":");
    while(sp != NULL) {
      sprintf(name, "%s/%s", sp, classname);
      if ((appresDB = XrmGetFileDatabase(name)) != NULL)
	break;
      sp = strtok(NULL, ":");
    }
  }
  else {
    sprintf(name, "%s/%s", getenv("HOME"), classname);
    appresDB = XrmGetFileDatabase(name);
  }
  XrmMergeDatabases(appresDB, &rDB);

  if (XResourceManagerString(display) != NULL)
    svDB = XrmGetStringDatabase(XResourceManagerString(display));
  else {
    sprintf(name, "%s/.Xdefaults", getenv("HOME"));
    svDB = XrmGetFileDatabase(name);
  }
  XrmMergeDatabases(svDB, &rDB);

  if (getenv("XENVIRONMENT") == NULL)
    sprintf(name, "%s/.Xdefaults-%s", getenv("HOME"), getenv("HOST"));
  else
    strcpy(name, getenv("XENVIRONMENT"));
  hmDB = XrmGetFileDatabase(name);
  XrmMergeDatabases(hmDB, &rDB);
  
  for (i = 0; i < 6; i++)
    fontstr[i] = fstr[i];

  for (i = 0; i < 7; i++)
    colstr[i] = colss[i];

  rp = rsc;
  while (rp->name != NULL) {
    if (XrmGetResource(rDB, rp->name, rp->class, str_type, &value) == True) {
      switch (rp->id)
	{
	case 0: case 1: case 2: case 3: case 4: case 5:
	  fontstr[rp->id] = (char *)malloc(value.size+1);
	  strncpy(fontstr[rp->id], value.addr, value.size);
	  fontstr[rp->id][value.size] = '\0';
	  break;
	case 6: case 7: case 8: case 9: case 10: case 11: case 12:
	  colstr[rp->id-6] = (char *)malloc(value.size+1);
	  strncpy(colstr[rp->id-6], value.addr, value.size);
	  colstr[rp->id-6][value.size] = '\0';
	  break;
	case 13:
	  strncpy(str, value.addr, value.size);
	  str[value.size] = '\0';
	  play_speed = atoi(str);
	}
    }
    rp++;
  }
}

void
init_color ()
{
  unsigned short add = 4096;

  cols.num = nametopixel("white");
  cols.plus = nametopixel("white");
  cols.minus = nametopixel("orange3");
  cols.title = nametopixel("orange1");

  cols.pai = nametopixel(PAICOL);
  cols.darkpai1 = make_darkcolor(cols.pai, add);
  cols.darkpai2 = make_darkcolor(cols.pai, add*2);
  cols.darkpai3 = make_darkcolor(cols.pai, add*4);

  cols.rev3 = nametopixel(colstr[0]);
  cols.rev1 = make_lightcolor(cols.rev3, add*2);
  cols.rev2 = make_lightcolor(cols.rev3, add);
  cols.rev4 = make_darkcolor(cols.rev3, add);
  cols.rev5 = make_darkcolor(cols.rev3, add*2);

  cols.dlgtx = nametopixel(colstr[1]);
  cols.btntx = nametopixel(colstr[2]);
  cols.nametx = nametopixel(colstr[3]);
  cols.kazetx = nametopixel(colstr[4]);

  cols.board = nametopixel(colstr[5]);
  cols.mess = nametopixel(colstr[6]);

  set_background_color(cols.board, add*2);
}
