
#==============================================================================#
# $Id: font.rb,v 1.11 2004/01/18 23:54:43 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/font.rb,v $
#==============================================================================#

require 'grb/font/gd_font'
require 'grb/font/true_type_font'

#==============================================================================#

module GRb

  class Font

    ALIGN_LEFT     = :left
    ALIGN_CENTER   = :center
    ALIGN_RIGHT    = :right
    ALIGN_FIT_LEFT = :fit_left

    VALIGN_TOP     = :top
    VALIGN_MIDDLE  = :middle
    VALIGN_BOTTOM  = :bottom
    VALIGN_FIT_TOP = :fit_top

    def initialize(font)
      @font = font
    end

    attr_reader :font

    def self.gd(name, bold = false, italic = false)
      return self.new(GDFont.new(name, bold, italic))
    end

    def self.truetype(filepath, size)
      return self.new(TrueTypeFont.new(filepath, size))
    end

    def draw(image, x, y, angle, color, text, align = ALIGN_LEFT, valign = VALIGN_TOP)
      angle %= 360
      xx, yy = x, y
      dx, dy = self.width(text, 0), self.height(text, 0)

      case align
      when ALIGN_LEFT
        # nop
      when ALIGN_CENTER
        xx -= MathEx.sin(angle + 90) * dx * 0.5
        yy -= MathEx.cos(angle + 90) * dx * 0.5
      when ALIGN_RIGHT
        xx -= MathEx.sin(angle + 90) * dx
        yy -= MathEx.cos(angle + 90) * dx
      when ALIGN_FIT_LEFT
        case angle
        when 0..90
          # nop
        when 90..180
          xx -= MathEx.sin(angle + 90) * dx
        when 180..270
          xx -= MathEx.sin(angle + 90) * dx
          xx += MathEx.cos(angle + 90) * dy
        when 270..360
          xx += MathEx.cos(angle + 90) * dy
        else raise(ArgumentError, 'invalid angle')
        end
      else raise(ArgumentError, 'invalid align')
      end

      case valign
      when VALIGN_TOP
        # nop
      when VALIGN_MIDDLE
        xx -= MathEx.sin(angle) * dy * 0.5
        yy -= MathEx.cos(angle) * dy * 0.5
      when VALIGN_BOTTOM
        xx -= MathEx.sin(angle) * dy
        yy -= MathEx.cos(angle) * dy
      when VALIGN_FIT_TOP
        case angle
        when 0..90
          yy -= MathEx.cos(angle + 90) * dx
        when 90..180
          yy -= MathEx.cos(angle + 90) * dx
          yy -= MathEx.sin(angle + 90) * dy
        when 180..270
          yy -= MathEx.sin(angle + 90) * dy
        when 270..360
          # nop
        else raise(ArgumentError, 'invalid angle')
        end
      else raise(ArgumentError, 'invalid valign')
      end

      @font.draw(image, xx, yy, angle, color, text)
    end

    def bound(text, angle = 0)
      return @font.bound(text, angle)
    end

    def width(text, angle = 0)
      return @font.width(text, angle)
    end

    def height(text, angle = 0)
      return @font.height(text, angle)
    end

    # Normal Font
    Giant  = self.gd('Giant')
    Large  = self.gd('Large')
    Medium = self.gd('Medium')
    Small  = self.gd('Small')
    Tiny   = self.gd('Tiny')

    # Bold Font
    BoldGiant  = self.gd('Giant',  true)
    BoldLarge  = self.gd('Large',  true)
    BoldMedium = self.gd('Medium', true)
    BoldSmall  = self.gd('Small',  true)
    BoldTiny   = self.gd('Tiny',   true)

    # Italic Font
    ItalicGiant  = self.gd('Giant',  false, true)
    ItalicLarge  = self.gd('Large',  false, true)
    ItalicMedium = self.gd('Medium', false, true)
    ItalicSmall  = self.gd('Small',  false, true)
    ItalicTiny   = self.gd('Tiny',   false, true)

    # Bold Italic Font
    BoldItalicGiant  = self.gd('Giant',  true, true)
    BoldItalicLarge  = self.gd('Large',  true, true)
    BoldItalicMedium = self.gd('Medium', true, true)
    BoldItalicSmall  = self.gd('Small',  true, true)
    BoldItalicTiny   = self.gd('Tiny',   true, true)

  end # Font

end # GRb

#==============================================================================#
#==============================================================================#
