
#==============================================================================#
# $Id: axis_major_grid.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/decorator/axis_major_grid.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/no_child_base'

#==============================================================================#

module GRb

  module Chart

    class AxisMajorGridDecorator < NoChildDecoratorBase

      def initialze
        @number = nil
        @color  = nil
      end

      attr_accessor :number, :color

      def draw(image, box)
        width  = (box.dx - 1).to_f / @number.to_f
        number = @number + 1

        number.times { |i|
          x = (box.x + width * i).ceil
          image.line(x, box.y, x, box.y2, @color)
        }
      end

    end # AxisMajorGridDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  GRb::Image.create_and_write_png_file(200, 200, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    GRb::Chart::Decorator::AxisMajorGrid.new.instance_eval {
      self.number = 10
      self.color  = GRb::Color.red(128)
      self.draw(image, GRb::Chart::Box.new(10, 10, 180, 180))
    }
  }
end

#==============================================================================#
#==============================================================================#
