
#==============================================================================#
# $Id: property.rb,v 1.2 2004/01/23 00:38:04 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/pie_3d/property.rb,v $
#==============================================================================#

require 'grb/chart/pie_base/property'

#==============================================================================#

module GRb

  module Chart

    class Pie3DChartProperty < PieChartPropertyBase

      def initialize
        super()
        @height = nil
        @shade  = nil
        self.setup
      end

      attr_accessor :height, :shade

      def setup
        super()

        @stretch             = false
        @height              = 20
        @shade               = 30
        @edge.visible        = true
        @edge.color          = GRb::Color.black
        @label.visible       = true
        @label.type          = :name
        @label.font.color    = GRb::Color.black
        @label.font.name     = GRb::Chart::Font::Small
        @label.font.vertical = false
        @label.font.filepath = nil
        @label.font.size     = 10
        @label.font.angle    = 0
        @label.line.color    = GRb::Color.black
        @label.line.length1  = 10
        @label.line.length2  = 30
      end

    end # Pie3DChartProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
