
#==============================================================================#
# $Id: scale.rb,v 1.2 2004/01/23 05:02:46 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/composite/scale.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/property/major_minor'
require 'grb/chart/base/property/font'

#==============================================================================#

module GRb

  module Chart

    class ScaleProperty < PropertyBase

      def initialize
        @maximum  = nil
        @minimum  = nil
        @interval = MajorMinorProperty.new(nil, nil)
        @grid     = MajorMinorProperty.new(ScaleGridProperty.new, ScaleGridProperty.new)
        @tics     = MajorMinorProperty.new(ScaleTicsProperty.new, ScaleTicsProperty.new)
        @origin   = ScaleOriginProperty.new
        @label    = ScaleLabelProperty.new
      end

      attr_accessor :maximum, :minimum
      attr_reader   :interval, :grid, :tics, :origin, :label

      class ScaleGridProperty

        def initialize
          @visible = nil
          @color   = nil
        end

        attr_accessor :visible, :color

      end # ScaleGridProperty

      class ScaleTicsProperty

        def initialize
          @visible = nil
          @color   = nil
          @size    = nil
          @inside  = nil
          @outside = nil
        end

        attr_accessor :visible, :color, :size, :inside, :outside

      end # ScaleTicsProperty

      class ScaleOriginProperty

        def initialize
          @visible = nil
          @color   = nil
        end

        attr_accessor :visible, :color

      end # ScaleOriginProperty

      class ScaleLabelProperty

        def initialize
          @visible = nil
          @format  = nil
          @font    = FontProperty.new
        end

        attr_accessor :format, :visible
        attr_reader   :font

      end # ScaleLabelProperty

    end # ScaleProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
