
#==============================================================================#
# $Id: legend.rb,v 1.1 2004/01/22 17:00:23 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/parts/legend.rb,v $
#==============================================================================#

require 'grb/chart/base/utility/text'

#==============================================================================#

module GRb

  module Chart

    class Legend

      def initialize(property)
        @property = property
        @fields   = []

        @spacing  = @property.interval
        @vertical = @property.vertical
      end

      # FIXME: using inject method
      def draw(image, box)
        if @vertical
          current = 0

          @fields.each { |field|
            field.draw(image, box.x, box.y + current)
            current += field.dy + @spacing
          }

          return current
        else
          current = box.x

          @fields.each { |field|
            field.draw(image, current, box.y)
            current += field.dx + @spacing
          }

          return current
        end
      end

      # FIXME: using inject method
      def dx
        if @vertical
          return 0 if @fields.empty?
          return @fields.collect { |field| field.dx }.max
        else
          return 0 if @fields.empty?

          current = 0
          @fields.each { |field| current += field.dx + @spacing }
          return current - @spacing
        end
      end

      # FIXME: using inject method
      def dy
        if @vertical
          return 0 if @fields.empty?

          current = 0
          @fields.each { |field| current += field.dy + @spacing }
          return current - @spacing
        else
          return 0 if @fields.empty?
          return @fields.collect { |field| field.dy }.max
        end
      end

      # FIXME: add => add_field
      def add(font, text, style = nil)
        @fields << Field.new(font, text, style, @property)
      end

      class Field

        def initialize(font, text, marker, property)
          @text      = Text.new(font, text)
          @marker    = marker
          @marker_dx = property.marker.width
          @marker_dy = property.marker.height
          @spacing   = property.marker.spacing
        end

        def draw(image, x, y)
          if @marker
            cy = y + self.dy / 2.0
            @marker.draw(image, Box.new(x, cy - @marker_dy / 2.0, @marker_dx, @marker_dy))
            @text.draw2(image, x + @marker_dx + @spacing, cy - @text.dy / 2.0)
          else
            @text.draw2(image, x, y)
          end

        end

        def dx
          if @marker
            return @text.dx + @spacing + @marker_dx
          else
            return @text.dx
          end
        end

        def dy
          if @marker
            return [@text.dy, @marker_dy].max
          else
            return @text.dy
          end
        end

      end # Field

      module Marker

        class Base

          def draw(image, box)
            raise "Don't use this class"
          end

        end # Base

        class Color < Base

          def initialize(fill_color, line_color)
            @fill_color = fill_color
            @line_color = line_color
          end

          def draw(image, box)
            image.rect(box.x, box.y, box.x2, box.y2, @line_color, @fill_color)
          end

        end # Color

        class Line < Base

          def initialize(color)
            @color = color
          end

          def draw(image, box)
            cy = box.y + box.dy / 2
            image.line(box.x, cy, box.x2, cy, @color)
          end

        end # Line

        class LineMarker < Base

          def initialize(color, marker)
            @color  = color
            @marker = marker
          end

          def draw(image, box)
            cx = box.x + box.dx / 2
            cy = box.y + box.dy / 2
            image.line(box.x, cy, box.x2, cy, @color)
            @marker.draw(image, cx, cy)
          end

        end # LineMarker

      end # Marker

    end # Legend

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
