// chordLayoutTest.cs created with MonoDevelop
// User: rob at 15:42 25/01/2008
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Collections;

namespace testing
{
	public class ChordLayoutTest
	{
		public ChordLayoutTest()
		{
		}
		
		public void testPossibleLayouts(int noChords)
		{
			int fakeNo, smallestWholeNo;
			ArrayList possibleLayouts = new ArrayList();
			fakeNo = noChords;
			//odd numbers of chords have the layouts as the next greatest even number of chords except for 1/noChords and noChords/1
			if((noChords %2) != 0){
				fakeNo++;
			}
			possibleLayouts.Add(new int[2]{1,noChords});
			
			smallestWholeNo = fakeNo;
			for (int i = 2; i <= (fakeNo/2);i++){
				int[] layout = new int[2];
				layout[0] = i;
				layout [1] = (int)Math.Ceiling((double)fakeNo/(double)i);
//				System.Console.WriteLine("i = {0}, fakeNo = {1}, fakeNo/i = {2}, columns = {3}", i, fakeNo, (double)fakeNo/(double)i,layout[1]);
				//when then check that there isn't already a more efficent packing
				//if not we add it to the possible packings
				if (layout[1] < smallestWholeNo){
					possibleLayouts.Add(layout);
					smallestWholeNo = layout[1];
				}
			}
			possibleLayouts.Add(new int[2]{noChords,1});

			Console.WriteLine("noOfChords = {0}", noChords);
			foreach (int[] layout in possibleLayouts){
				Console.WriteLine("rows = {0}, columns = {1}", layout[0], layout[1]);
			}
			Console.WriteLine("");
		}	
	}
}