using Gtk;

namespace gnomeguitar_cs
{
	
	public class VoiceingsOM : ComboBox
	{
		ObjGroup voiceings;
		ListStore listStore;
		
		public VoiceingsOM()
		{
			listStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = listStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
		}
		
		public VoiceingsOM(ObjGroup voiceings):this()
		{
			set_voiceings(voiceings);
		}
		
		public void set_voiceing(Voiceing voiceing)
		{
			//Do we still need to fire the changed event if the voiceing is set to the currently selected voiceing?
			
			if(voiceing == null){
				Active = 0;
			} else {
				Active = voiceings.position_equal(voiceing);
			}		
		}

		public Voiceing get_voiceing()
		{
			return (Voiceing)voiceings.nth(Active);
		}

		public void set_voiceings(ObjGroup voiceings)
		{
			listStore.Clear();
			for(int i = 0; i < voiceings.get_no();i++){
				listStore.AppendValues(i.ToString());
			}
			this.voiceings = voiceings;
			Active = 0;
		}	
	}
}