using Gtk;

namespace gnomeguitar_cs
{
	
	public class TreeNodeTypesOM : ComboBox
	{
		ObjGroup treeNodeTypes = null;
		ListStore listStore;
		
		public TreeNodeTypesOM()
		{
			listStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = listStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
		}
		
		public TreeNodeTypesOM(ObjGroup treeNodeTypes): this()
		{
			set_treeNodeTypes(treeNodeTypes);
		}
		
		public void set_treeNodeType(ChordTreeNodeType treeNodeType)
		{
			//Do we still need to fire the changed event if the treeNodeType is set to the currently selected treeNodeType?
			
			if(treeNodeType == null){
				Active = 0;
			} else {
				Active = treeNodeTypes.position_equal(treeNodeType);
			}		
		}

		public ChordTreeNodeType get_treeNodeType()
		{
			return (ChordTreeNodeType)treeNodeTypes.nth(Active);
		}

		public void set_treeNodeTypes(ObjGroup treeNodeTypes)
		{
			listStore.Clear();
			foreach (ChordTreeNodeType chordTreeNodeType in treeNodeTypes){
				listStore.AppendValues(chordTreeNodeType.to_text());
			}
			this.treeNodeTypes = treeNodeTypes;
			Active = 0;
		}	
		
		public void remove_treeNodeType(ChordTreeNodeType type)
		{
			TreeIter iter;
			int position = treeNodeTypes.position_equal(type);
			//System.Console.WriteLine("TreeNodeTypesOM.remove_treeNodeType: type = {0}, position = {1}", type.to_text(), position);
			treeNodeTypes.remove_by_index(position);
			listStore.GetIter(out iter, new TreePath(new int[]{position}));
			listStore.Remove(ref iter);
			Active = 0;
		}
		
		public void append_treeNodeType(ChordTreeNodeType type)
		{
			if (treeNodeTypes == null){
				treeNodeTypes = new ObjGroup();
			}
			treeNodeTypes.append(type);
			listStore.AppendValues(type.to_text());
		}
	}
}