using System;
using Gtk;

namespace gnomeguitar_cs
{
	
	public class TreeCreator : Dialog
	{
		ChordFilter chordFilter;
		ChordScaleFilter chordScaleFilter;
		ChordGroup subGroup;
		TreeLayout layout;
		TreeNodeTypesOM treeNodeTypesOM, rTreeNodeTypesOM;
		ChordList chordList;
		Button addButton, removeButton;
		Entry nameEntry;
		
		public TreeCreator()
		{
			Title = "Tree Creator";
			TypeHint = Gdk.WindowTypeHint.Dialog;
			AddButton(Stock.Ok, ResponseType.Ok);
			AddButton(Stock.Cancel, ResponseType.Cancel);
			layout = new TreeLayout();
			SetDefaultSize(275,400);     
			build_widget();
		}

		
		public TreeCreator(ChordGroup chords): this ()
		{
			set_chords(chords);
		}
	
		public void set_chords(ChordGroup chords)
		{	
			chordFilter.set_chords(chords);
		}

		public ChordGroup get_subGroup()
		{
			return subGroup;
		}

		public TreeLayout get_treeLayout()
		{
			TreeLayout newLayout = new TreeLayout(layout);
			newLayout.append(new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD));
			
			return newLayout;
		}
		
		public string get_name()
		{
			return nameEntry.Text;
		}
		
/*********************************************************
 ********************PRIVATE STUFF************************
 ********************************************************/

		void build_widget()
		{
			this.VBox.BorderWidth =  5;
			this.VBox.Spacing =  5;
			
			Notebook nb = new Notebook();
			VBox.PackStart(nb, false, false, 0);
			
			chordFilter = new ChordFilter();
			chordFilter.onChanged += chordFilter_changed_cb;
			nb.AppendPage(chordFilter, new Label("Chord Filter"));
			
			chordScaleFilter = new ChordScaleFilter();
			chordScaleFilter.onChanged += chordScaleFilter_changed_cb;
			nb.AppendPage(chordScaleFilter, new Label("Scale Filter"));
			
			HBox nameBox = new HBox(false, 5);
			nameBox.PackStart(new Label("Tree Name:"), false, false, 0);
			nameEntry = new Entry("New Tree");
			nameEntry.Changed += nameEntry_cb;
			nameBox.PackStart(nameEntry, true, true, 0);
			VBox.PackStart(nameBox, false, false, 0);
			
			chordList = new ChordList("Tree Preview");
			ScrolledWindow scrolledWindow = new ScrolledWindow();
			scrolledWindow.HscrollbarPolicy = PolicyType.Always;
			scrolledWindow.VscrollbarPolicy = PolicyType.Always;
			scrolledWindow.ShadowType = ShadowType.In;		
			scrolledWindow.Add(chordList);
			VBox.PackStart(scrolledWindow, true, true, 0);
			
			ObjGroup treeNodeTypes = new ObjGroup();
			ChordTreeNodeTypeValue[] treeNodeTypesOMTypes = {
				ChordTreeNodeTypeValue.TUNING,
				ChordTreeNodeTypeValue.CHORD_TYPE,
				ChordTreeNodeTypeValue.CHORD_ROOT,
				ChordTreeNodeTypeValue.CHORD_SHAPE,
			};	
				
			foreach (ChordTreeNodeTypeValue ctntv in treeNodeTypesOMTypes){
				treeNodeTypes.append(new ChordTreeNodeType(ctntv));
			}
			
			HBox omBox = new HBox(false, 5);
			//omBox.BorderWidth = 5;

			addButton = new Button(Gtk.Stock.Add);
			addButton.Clicked += new EventHandler(addOMButton_cb);
			omBox.PackStart(addButton, false, false, 0);
			
			treeNodeTypesOM = new TreeNodeTypesOM(treeNodeTypes);
			omBox.PackStart(treeNodeTypesOM, true, true, 0);
			treeNodeTypesOM.Show();
						
			VSeparator separator = new VSeparator();
			omBox.PackStart(separator, false, false, 0);
			
			removeButton = new Button(Gtk.Stock.Remove);
			removeButton.Clicked += new EventHandler(removeOMButton_cb);
			removeButton.Sensitive = false;
			omBox.PackStart(removeButton, false, false, 0);
			rTreeNodeTypesOM = new TreeNodeTypesOM();
			omBox.PackStart(rTreeNodeTypesOM, true, true, 0);
			rTreeNodeTypesOM.Sensitive = false;
			rTreeNodeTypesOM.Show();
			VBox.PackStart(omBox,false,false,0);
		}

       void set_chordTree()
		{
			TreeLayout newLayout = new TreeLayout(layout);
			newLayout.append(new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD));
			//System.Console.WriteLine("TreeCreator.set_chordTree: subGroup = 0, layout = {0}", newLayout.to_text());
			//FIXME SHOULD Really be changing the chordTree rather than setting a new one!
			chordList.set_chordTree(subGroup, newLayout, nameEntry.Text);
			chordList.ExpandAll();
		}
/*****************************************************************
 ***********************CALLBACKS*********************************
 ****************************************************************/
 
		void chordFilter_changed_cb(object obj, EventArgs args)
		{
			ChordGroup subGroup;

			subGroup = chordFilter.get_subGroup();
			chordScaleFilter.set_chords(subGroup);
		}
		
		void chordScaleFilter_changed_cb(object obj, EventArgs args)
		{
			//System.Console.WriteLine("TreeCreator.chordScaleFilter_changed_cb: chordScaleFilter changed");
			subGroup = chordScaleFilter.get_subGroup();
			set_chordTree();
		}	
		
		void addOMButton_cb(object o, EventArgs args)
		{
			ChordTreeNodeType type = treeNodeTypesOM.get_treeNodeType();
			layout.append_nodeType(type);
			set_chordTree();
			treeNodeTypesOM.remove_treeNodeType(type);
			rTreeNodeTypesOM.append_treeNodeType(type);
			if(!removeButton.Sensitive){
				removeButton.Sensitive = true;
				rTreeNodeTypesOM.Sensitive = true;
				rTreeNodeTypesOM.Active = 0;
			}
			if (layout.size() == 4){
				addButton.Sensitive = false;
				treeNodeTypesOM.Sensitive = false;
			}
			
		}
		
		void removeOMButton_cb(object o, EventArgs args)
		{
			ChordTreeNodeType type = rTreeNodeTypesOM.get_treeNodeType();
			layout.remove_nodeType(type);
			set_chordTree();
			rTreeNodeTypesOM.remove_treeNodeType(type);
			treeNodeTypesOM.append_treeNodeType(type);
			if(!addButton.Sensitive){
				addButton.Sensitive = true;
				treeNodeTypesOM.Sensitive = true;
				treeNodeTypesOM.Active = 0;
			}
			if (layout.size() == 0){
				removeButton.Sensitive = false;
				rTreeNodeTypesOM.Sensitive = false;
			}
		
		}
		
		void nameEntry_cb(object o, EventArgs args)
		{
			chordList.set_chordTree_name(0, nameEntry.Text);
		}
	}
}