using Gtk;
using System;

namespace gnomeguitar_cs
{
	
	public class ShapesOM : ComboBox
	{
		ObjGroup shapes;
		ListStore listStore;
		bool frozen = false;
		
		public delegate void ChangedHandler (object obj, EventArgs args);		
		public new event ChangedHandler Changed;
		
		public ShapesOM()
		{
			base.Changed += baseOnChangedHandler;
			listStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = listStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
		}
		
		public ShapesOM(ObjGroup shapes): this()
		{
			set_shapes(shapes);
		}
		
		public void set_shape(ChordShape shape)
		{
			//Do we still need to fire the changed event if the shape is set to the currently selected shape?
			
			if(shape == ChordShapeValue.NO_SHAPE){
				Active = 0;
			} else {
				Active = shapes.position_equal(shape);
			}		
		}

		public ChordShape get_shape()
		{
			return Active == -1? new ChordShape(ChordShapeValue.NO_SHAPE):(ChordShape)shapes.nth(Active);
		}

		public void set_shapes(ObjGroup shapes)
		{
			frozen = true;
			listStore.Clear();
			foreach (ChordShape shape in shapes){
				listStore.AppendValues(shape.to_text());
			}
			this.shapes = shapes;
			frozen = false;
			Active = 0;
//			if(onChanged != null && !frozen){onChanged(this, new EventArgs());}
		}
		
		void baseOnChangedHandler(object obj, EventArgs args)
		{
			if(Changed != null && !frozen){Changed(this, new EventArgs());}
		}
	}
}