using System;
using Gtk;

namespace gnomeguitar_cs
{
	public class ScaleTypesOM:ComboBox {
		
		ObjGroup scaleTypes = new ObjGroup();
		ListStore listStore;
		bool useAny = false;
		
		public ScaleTypesOM ()
		{
			build_widget();
		}

		public ScaleTypesOM(bool useAny)
		{
			this.useAny = useAny;
			build_widget();
		}

		public ScaleType get_scaleType()
		{
			return (ScaleType)scaleTypes.nth(Active);
		}
		
		void build_widget()
		{
			listStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = listStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
			
			foreach (ScaleTypeValue stv in ScaleType.ScaleTypes)
			{					
				if((stv == ScaleTypeValue.ANY && !useAny)
				   || stv == ScaleTypeValue.NONE
				   || stv == ScaleTypeValue.UNKNOWN){continue;}
				ScaleType scaleType = new ScaleType(stv);
				scaleTypes.append(scaleType);
				listStore.AppendValues(scaleType.to_text());
			}
			Active = 0;
		}
	}
}