using System;
using Gtk;

namespace gnomeguitar_cs
{
	public class ScaleModesOM:ComboBox {
		
		bool useAny = false;
		ListStore realStore;
		ListStore naStore;
		
		public ScaleModesOM ()
		{
			realStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			naStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = realStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
			naStore.AppendValues("N/A");
		}
		
		public ScaleModesOM (bool useAny): this()
		{
			use_any(useAny);
		}	
		
		public ScaleModesOM (ScaleType type): this ()
		{
			set_scale(type);
		}

		public void use_any (bool useAny)
		{
			this.useAny = useAny;
		}

		public int get_mode()
		{
			//umm i'm confused about whats going on
			//rember scale modes start at 1 but internally they start at 0
			//except if "Any" is present then that is the first item
			//System.Console.WriteLine("ScaleModesOM.get_mode: useAny = {0}, Active = {1}", useAny, Active);
			return useAny?Active-1:Active;
		}

		public void set_scale(ScaleType scaleType)
		{
			//rember modes start 1 but internally they start at 0
			//except if "Any" is present then that is the first item
			
			//creating a new listStore is the simplest way i could find to stop the changed signal
			//being emited before we're finished setting it up
			ListStore ls = new ListStore(new GLib.GType[]{GLib.GType.String});
			int noModes = scaleType.get_noModes();
			if(useAny){
				ls.AppendValues("Any");
			}
			for (int i = 0; i < noModes; i++){
				ls.AppendValues(scaleType.get_modeName(i));
			}		
			realStore = ls;
			set_na(false);
			Active = 0;
		}	

		public void set_na(bool na)
		{
			if (na){
				Model = naStore;
				Sensitive = false;
				Active = 0;
			} else {
				Model = realStore;
				Active = 0;
				Sensitive = true;
			}		
		}
	}
}
