using System;
using Gtk;

namespace gnomeguitar_cs
{
	public class ScaleList : Frame
	{
		Table table = null;
		
		public ScaleList (): base(){
			build_widget();
		}	

		public ScaleList(Scale scale) : this ()
		{
			
			set_scale(scale);
		}
		
		void build_widget()
		{	
			Shadow = ShadowType.None;
			BorderWidth = 5;
		}

		public void set_scale (Scale scale)
		{
			int i = 0;

			string noteText = null;
			Label titleLabel = null;
			Label noteLabel = null;
			int newNoNotes;
			Frame frame = null;
			FretNo fretNo = null;
		
			if(table != null){
				Remove(table);
			}
			newNoNotes = scale.get_noNotes();
			table = new Table(2, (uint)newNoNotes, true);
			Add(table);
			i=0;
			foreach (Note note in scale.get_notes()){ 
		//		System.Console.WriteLine(ScaleList.set_scale: note.to_text());
				fretNo = new FretNo(i + 1);
				titleLabel = new Label(fretNo.to_roman_numerals());
		//		titleLabel.SetPadding(2, 2);
				frame = new Frame(null);
				frame.Shadow = ShadowType.Out;
				frame.Add(titleLabel);
				//button = gtk_button_new_with_label(titleText);
				table.Attach(frame,
				             (uint)i,(uint) i + 1, 
				             (uint)0, (uint)1,
				             AttachOptions.Expand | AttachOptions.Fill,
				             AttachOptions.Expand | AttachOptions.Fill, 
				             (uint)0, (uint)0);
				noteText = note.to_text();
				noteLabel = new Label(noteText);
				table.Attach(noteLabel,
				             (uint)i, (uint)i + 1, 
				             (uint)1, (uint)2,
				             AttachOptions.Expand | AttachOptions.Fill,
				             AttachOptions.Expand | AttachOptions.Fill,
				             (uint)0, (uint)0);
				i++;
			}
			ShowAll();
		}	
	}
}