using Gtk;

namespace gnomeguitar_cs
{
	
	public class PrioritiesOM : ComboBox
	{
		ObjGroup priorities;
		ListStore listStore;
		
		public PrioritiesOM()
		{
			listStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = listStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
			
			priorities = new ObjGroup();
			for(short i = 1; i < 11; i++){
				priorities.append(new Priority(i));
			}
			set_priorities(priorities);
		}
		
		public PrioritiesOM(ObjGroup priorities): this()
		{
			set_priorities(priorities);
		}
		
		public void set_priority(Priority priority)
		{
			Active = priorities.position_equal(priority);
			//System.Console.WriteLine("Priority.set_priority: priority = {0}, positoin = {1}", priority.to_text(), priorities.position_equal(priority)); 
		}

		public Priority get_priority()
		{
			return (Priority)priorities.nth(Active);
		}

		public void set_priorities(ObjGroup priorities)
		{
			listStore.Clear();
			foreach (Priority priority in priorities){
				listStore.AppendValues(priority.to_text());
			}
			this.priorities = priorities;
			Active = 0;
		}	
	}
}