using Gtk;

namespace gnomeguitar_cs
{
	
	public class FingersOM : ComboBox
	{
		ObjGroup fingers;
		ListStore listStore;
		
		public FingersOM()
		{
			listStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = listStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
			fingers = new ObjGroup();
			fingers.append(new Finger(FingerValue.NOT_USED));
			fingers.append(new Finger(FingerValue.NO_FINGER));
			fingers.append(new Finger(FingerValue.INDEX));
			fingers.append(new Finger(FingerValue.MIDDLE));
			fingers.append(new Finger(FingerValue.RING));
			fingers.append(new Finger(FingerValue.LITTLE));
			fingers.append(new Finger(FingerValue.THUMB));
			set_fingers(fingers);
		}
		
		public FingersOM(ObjGroup fingers):this()
		{
			set_fingers(fingers);
		}
		
		public void set_finger(Finger finger)
		{
			Active = fingers.position_equal(finger);
		}

		public Finger get_finger()
		{
			return (Finger)fingers.nth(Active);
		}

/*********************************************************
 ********************PRIVATE STUFF************************
 ********************************************************/

		void set_fingers(ObjGroup fingers)
		{
			listStore.Clear();
			foreach (Finger finger in fingers){
				listStore.AppendValues(finger.to_text());
			}
			this.fingers = fingers;
			Active = 0;
		}	
	}
}