namespace gnomeguitar_cs
{
	public enum ChordTreeNodeTypeValue{
		NONE,
		ROOT,
		LABEL,
		TUNING,	
		CHORD_TYPE,
		CHORD_SHAPE,
		CHORD_ROOT,
		CHORD
	}
	
	public class ChordTreeNodeType{
		
		ChordTreeNodeTypeValue type;

		public ChordTreeNodeType(ChordTreeNodeTypeValue type)
		{	
			this.type=type;
		}
		
		public ChordTreeNodeType(string text)
		{
	
			//Null is legal it means no type

			if(text == null){
				type = ChordTreeNodeTypeValue.NONE;
			} else if (text == "Root"){
				type = ChordTreeNodeTypeValue.ROOT;			
			} else if (text == "Label"){
				type = ChordTreeNodeTypeValue.LABEL;
			} else if (text == "Tuning"){
				type = ChordTreeNodeTypeValue.TUNING;
			} else if (text == "Chord Type"){
				type = ChordTreeNodeTypeValue.CHORD_TYPE;
			} else if (text == "Chord Shape"){
				type = ChordTreeNodeTypeValue.CHORD_SHAPE;
			} else if (text == "Chord Root"){
				type = ChordTreeNodeTypeValue.CHORD_ROOT;
			} else if (text == "Chord"){
				type = ChordTreeNodeTypeValue.CHORD;
			}
		}
       
		public string to_text()
		{
			string text = null;

			switch (type){
			case ChordTreeNodeTypeValue.NONE: 
				break;
			case ChordTreeNodeTypeValue.ROOT:
				text = "Root";
				break;
			case ChordTreeNodeTypeValue.LABEL:
				text = "Label";
				break;
			case ChordTreeNodeTypeValue.TUNING:
				text = "Tuning";
				break;
			case ChordTreeNodeTypeValue.CHORD_TYPE:
				text = "Chord Type";
				break;
			case ChordTreeNodeTypeValue.CHORD_SHAPE:
				text = "Chord Shape";
				break;
			case ChordTreeNodeTypeValue.CHORD_ROOT:
				text = "Chord Root";
				break;
			case ChordTreeNodeTypeValue.CHORD:
				text = "Chord";
				break;
			}

			return text;
		}
		
		public static bool operator == (ChordTreeNodeType x, ChordTreeNodeType y) {
			return x.type == y.type;
		}
		
		public static bool operator != (ChordTreeNodeType x, ChordTreeNodeType y) {
			return x.type != y.type;
		}
		
		public override bool Equals(object o) {
			if(!(o is ChordTreeNodeType))
				return false;
			return this == (ChordTreeNodeType)o;
		}
		
		public override int GetHashCode()
		{
			return (int)type;
		}
		
		public static implicit operator ChordTreeNodeTypeValue(ChordTreeNodeType x) {
			return x.type;
		}

	}
}