using System;
using Gtk;
using Rsvg;
using GConf;

namespace gnomeguitar_cs
{
	public class ChordSVGRendererUI : ChordSVGRenderer, ChordRendererUI
	{
		string path = "/apps/gnome-guitar/libgnomeguitarui/gchordSVGRenderer/";
 
		Image image = new Image ();
		Handle svgHandle = new Handle();
		Client client = new Client();
		
		public ChordSVGRendererUI(): base ()
		{
			svgHandle.SizeCallback = svg_size_func;
			client.AddNotify (path, new NotifyEventHandler (prefs_changed_cb));
		}
		
		public ChordSVGRendererUI(ChordGroup chords): this ()
		{
			render(chords);
		}

		public void render(ChordGroup chords)
		{
			this.chords = chords;
			render();
		}
		
		public void render()
		{	
			Gdk.Pixbuf svgPixbuf;
			string svg;
			
//Presumably in can just clear it somehow
//			if(self->svgHandle != NULL){
//		rsvg_handle_free(self->svgHandle);
//		self->svgHandle = rsvg_handle_new();
//	}

			svg = ((ChordSVGRenderer)this).render();
			System.Console.WriteLine("ChordSVGRenderer.render: FIXME DON'T KNOW HOW TO SET UP SVG RENDERER");		
//			svgHandle.Write(((byte[])svg.ToCharArray()), svg.Length);
			svgPixbuf = svgHandle.Pixbuf;			
			image = new Image(svgPixbuf);
			svgHandle.Close();
		}
		
		public void clear()
		{
			System.Console.WriteLine("ChordSVGRenderer.clear: FIXME Don't know how to clear the svg renderer.");
		}
		
		public void render_default()
		{
			Chord chord = new Chord(new Note(NoteValue.C));
			chords = new ChordGroup (new Chord[]{chord});
			render();
		}
		
		public Widget get_widget()
		{
			return image;
		}


/******************************************************************
 *********************CALLBACKS***********************************
 *****************************************************************/

		void prefs_changed_cb(object o, EventArgs args)
		{
			render(chords);
		}

		void svg_size_func (out int width, out int height)
		{
			
			int noChords;
			int xChords;
			double chordXPadding;
			double chordWidth, windowWidth;
			double widthRatio, heightRatio = 1;

			switch((ZoomValue)defaultZoom){
			case ZoomValue.FIT_CHORD_TO_WINDOW:
				noChords = chords.get_no(); 
				if (chordsPerRow > noChords){
					//FIXME Don't know what's going on here
					//noChords = xChords;
				}
		
				chordXPadding = this.chordXPadding * noChords * 2;
				chordWidth = (image.Allocation.Width - chordXPadding) /noChords;
				windowWidth = image.Allocation.Width;
				widthRatio = windowWidth/chordWidth;
				width = (int)(chordWidth * widthRatio);
				height = (int)(image.Allocation.Height * heightRatio);
				break;
			case ZoomValue.FIT_ALL_CHORDS_TO_WINDOW:
				width = image.Allocation.Width;
				height = image.Allocation.Height;
				break;
			case ZoomValue.CUSTOM: 
				width = (int)customZoomWidth;
				height = (int)customZoomHeight;
				break;
			default : width = 0; height = 0; break;
			}	
		}
	}
}