using System;
using Gtk;

namespace gnomeguitar_cs
{
	
	public class ChordList : NodeView
	{	
		ChordTreeRoot chordTreeRoot = new ChordTreeRoot();
	//	NodeView nodeView;
		
		public delegate void SelectionChangedHandler (object objGroup, 
		                                              EventArgs args);
		
		public event SelectionChangedHandler onSelectionChanged;		
	
		public ChordList ()
		{
			this.NodeStore = new NodeStore(typeof(ChordTreeNode));
			AppendColumn ("Chord Trees", new CellRendererText (), new NodeCellDataFunc (DataCallback));
			build_widget();
			connect_signals();
			Selection.Mode = SelectionMode.Multiple;
		}
		
		public ChordList (string name)
		{
			this.NodeStore = new NodeStore(typeof(ChordTreeNode));
			AppendColumn (name, new CellRendererText (), new NodeCellDataFunc (DataCallback));
			build_widget();
			connect_signals();
		}
		
		public ChordList(ChordGroup chords):this()
		{
			add_chordTree(chords, new TreeLayout(new ChordTreeNodeType(ChordTreeNodeTypeValue.TUNING),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD_SHAPE),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD_TYPE),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD_ROOT)));
		}
	
		public void add_chordTree(ChordGroup chords, TreeLayout layout)
		{	
			chordTreeRoot.add_tree(chords, layout,-1);
			NodeStore.AddNode(chordTreeRoot.nth(chordTreeRoot.get_no() -1) as ITreeNode);
		}
		
		public void add_chordTree(ChordGroup chords, TreeLayout layout, string layoutName)
		{	
			//System.Console.WriteLine("ChordList2.add_chordTree: layout Name = {0}", layoutName);
			chordTreeRoot.add_tree(chords, layout,-1, layoutName);
			ITreeNode itn = chordTreeRoot.nth(chordTreeRoot.get_no() -1) as ITreeNode;
			NodeStore.AddNode(itn);
			ExpandAll();
			NodeSelection.UnselectAll();
			NodeSelection.SelectNode(itn);
			ScrollToCell(new TreePath(new int[]{chordTreeRoot.get_no() -1}),null,true,0,0);
//			nodeStore.AddNode(chordTreeRoot.nth(0) as ITreeNode);
			//System.Console.WriteLine("ChordList2.add_chordTree: ChordList set up");
		}
		
		public void set_chordTree(ChordGroup chords, TreeLayout layout)
		{		
			chordTreeRoot.clear();
			NodeStore.Clear();
			add_chordTree(chords, layout);
		}
		
		public void set_chordTree(ChordGroup chords, TreeLayout layout, string name)
		{		
			chordTreeRoot.clear();
			NodeStore.Clear();
			add_chordTree(chords, layout, name);
		}
		private void DataCallback (TreeViewColumn col, CellRenderer cell, ITreeNode node)
		{
			(cell as CellRendererText).Text = (node as ChordTreeNode).get_string_rep();
		}
		
//		public ChordGroup get_selected_chords()
//		{
//			ChordGroup chords = new ChordGroup();
//			
//			foreach (ITreeNode node in NodeSelection.SelectedNodes){
//				foreach(Chord chord in (node as ChordTreeNode).get_chords()){
//					chords.append(chord);	
//				}
//			}
//			return chords;
//		}

		public ChordGroup get_selected_chords()
		{
			ChordGroup chords = new ChordGroup();
			
			foreach (ITreeNode node in NodeSelection.SelectedNodes){
				(node as ChordTreeNode).append_chords(chords);
			}
			return chords;
		}
		public string get_chordXml()
		{
				return get_selected_chords().to_xml();
		}

		public bool is_chord_selected()
		{
			return NodeSelection.SelectedNodes.Length > 0;
		}

		public void select_chord(Chord chord)
		{	
			ChordTreeNode chordTreeNode = chordTreeRoot.get_chord_node(chord);
			NodeSelection.SelectNode(chordTreeNode);			
		}
		
		public void set_chordTree_name(int index, string name)
		{
			ChordTreeNode node = (ChordTreeNode)NodeStore.GetNode(new TreePath(new int[]{0}));
			node.get_node_data().set_label(name);
		}

		public void remove_selected()
		{
			foreach (ITreeNode itn in NodeSelection.SelectedNodes){
				NodeStore.RemoveNode(itn);
			}
			//NodeSelection.SelectPath(new TreePath(new int[]{0}));
		}
		
		public bool is_root_selected()
		{
			bool rootSelected = false;
			foreach (ChordTreeNode ctn in NodeSelection.SelectedNodes){
				if(ctn.get_depth() == 1){
					rootSelected = true;
					break;
				}
			}
			return rootSelected;
		}
	
/*********************************************************
 ********************PRIVATE STUFF************************
 ********************************************************/

		void build_widget()
		{
		
		}

//		Chord get_single_selected_voiceing_chord()
//		{
//			Voiceing currentVoiceing;
//			string name;
//			ChordType type;
//			Note root;
//			ChordShape shape;
//			Construction construction;
//			WrittenGroup writtens;
//			Chord voiceingChord;
//			Chord currentChord;
//			ChordGroup chords;
//
//			chords = get_selected_chords();
//			currentChord = (Chord)chords.nth(0);
//	
//			if (currentChord.get_noVoiceings() != 1){
//				name = currentChord.get_name();
//				type = currentChord.get_chordType();
//				root = currentChord.get_root();
//				shape = currentChord.get_shape();
//				construction = currentChord.get_construction();
//				writtens = currentChord.get_writtens();
//
//				voiceingChord = new Chord();
//				voiceingChord.set_name(name);
//				voiceingChord.set_type(type);
//				voiceingChord.set_root(root);
//				voiceingChord.set_construction(construction); 
//				voiceingChord.set_writtens(writtens);
//				voiceingChord.set_shape(shape);
//				currentVoiceing = currentChord.get_voiceing(0);
//
//				voiceingChord.add_voiceing(currentVoiceing);
//				currentChord = voiceingChord;
//			}
//			return currentChord;
//		}

/******************************************************
 ********************CALLBACKS*************************
 ******************************************************/

		void connect_signals()
		{
			NodeSelection.Changed += new EventHandler(selection_changed_cb);
		}

		void selection_changed_cb(object o, EventArgs args)
		{
			if(onSelectionChanged != null){onSelectionChanged(this, new EventArgs());}
		}
	}
}
