using System;
using System.Xml;

namespace gnomeguitar_cs
{
	public class XmlChordParser
	{
		enum State {
			OUT, CHORDS, CHORD, TYPE, ROOT,
			KEY, SHAPE, CONSTRUCTION,
			WRITTEN, VOICEING, TUNING,
			PRIORITY, INFO, STRING, TUNED,
			FRETTED, FRET_NO, RELATION, FINGER
		} 
		
		string supportedDbVersion="1.0";
		XmlTextReader reader;
		Chord currentChord;
		Voiceing currentVoiceing;
		GuitarString currentString;
		string currentText;
		State currentState;
		ChordGroup theChords;
		int i;
		
	
		public XmlChordParser(FileReader fileReader) {
			reader = new XmlTextReader(fileReader.reader);
			theChords = new ChordGroup();
		}
		
		public ChordGroup parse ()
		{			
			while (reader.Read())
			{
				switch (reader.NodeType)
				{
				case XmlNodeType.Element:
					start_element();
					break;
				case XmlNodeType.Text:
					currentText = reader.Value;
					break;
				case XmlNodeType.CDATA:
//					Console.Write("<![CDATA[{0}]]>", reader.Value);
					break;
				case XmlNodeType.ProcessingInstruction:
//					Console.Write("<?{0} {1}?>", reader.Name, reader.Value);
					break;
				case XmlNodeType.Comment:
//					Console.Write("<!--{0}-->", reader.Value);
					break;
				case XmlNodeType.XmlDeclaration:
//					Console.Write("<?xml version='1.0'?>");
					break;
				case XmlNodeType.Document:
					break;
				case XmlNodeType.DocumentType:
//					Console.Write("<!DOCTYPE {0} [{1}]", reader.Name, 
//					              reader.Value);
					break;
				case XmlNodeType.EntityReference:
//					Console.Write(reader.Name);
					break;
				case XmlNodeType.EndElement:
					end_element();
					break;
				}  	
			}	
			return theChords;
		}		

		void start_element ()
		{
		//	Console.Write(currentState + "\n");
			switch (currentState){
			case State.OUT:
				if (reader.GetAttribute(0) != supportedDbVersion){
					System.Console.WriteLine("XMLChordParser.start_element: You have mismatched app and db versions. Strang things may happen.");
				}
				currentState = State.CHORDS;
				break;
			case State.CHORDS:
				//System.Console.WriteLine("XMLChordParser.start_element: Parseing chord: {0}", i);
				i++;
				currentChord = new Chord(true);
				if (reader.AttributeCount != 0){
					currentChord.set_name(reader.GetAttribute(0)) ;
				}	
				currentState = State.CHORD;
				break;
			case State.CHORD:
				switch (reader.Name){
				case "type":
					currentState = State.TYPE;
					break;
				case "root":
					currentState = State.ROOT;
					break;
				case "key":
					currentState = State.KEY;
					break;
				case "shape":
					currentState = State.SHAPE;
					break;
				case "construction":
					currentState = State.CONSTRUCTION;
					break;
				case "written":
					currentState = State.WRITTEN;
					break;
				case "voiceing":
					currentVoiceing = new Voiceing();
					currentChord.add_voiceing (currentVoiceing);
					currentState = State.VOICEING;
					break;
				default: Console.WriteLine("Bugger " + reader.Name); break;
				}
				break;
			case State.VOICEING:
				switch (reader.Name){
				case "tuning":
					currentState = State.TUNING;
					break;
				case "priority":
					currentState = State.PRIORITY;
					break;
				case "info":
					currentState = State.INFO;
					break;
				case "guitarString":
					//Console.WriteLine("hello");
					currentString = new GuitarString();
					currentVoiceing.add_string(currentString);
					currentState = State.STRING;
					break;
				}			
				break;
			case State.STRING:
				switch (reader.Name){
				case "tuned":
					currentState = State.TUNED;
					break;
				case "fretted":
					currentState = State.FRETTED;
					break;
				case "fretNo":
				currentState = State.FRET_NO;
					break;
				case "relation":
					currentState = State.RELATION;
					break;
				case "finger":
				currentState = State.FINGER;
					break;
				}		
				break;	
				/*	case State.TYPE:
	case State.ROOT:
	case State.KEY:
	case State.SHAPE:
	case State.CONSTRUCTION:
	case State.WRITTEN:
	case State.TUNING:
	case State.PRIORITY:
	case State.INFO:
	case State.TUNED:
	case State.FRETTED:
	case State.FRET_NO:
	case State.RELATION:
	case State.FINGER:
		break;
	}*/	
			}	
		}
	
		void end_element ()
		{
	//		Console.WriteLine("state = " + currentState + " currentText = " + currentText);
			switch (currentState){
			case State.CHORDS:
				currentState = State.OUT;
				break;
			case State.CHORD:
				currentChord.keysDirty = false;
				currentChord.possibleNotesDirty = true;				
				theChords.append(currentChord);
				currentChord = null;
				currentState = State.CHORDS;
				break;
			case State.TYPE:
				currentChord.set_type(new ChordType(currentText));
				currentText = null;
				currentState = State.CHORD;
				break;	
			case State.ROOT:
				currentChord.set_root(new Note(currentText));
				currentText = null;
				currentState = State.CHORD;
				break;
			case State.SHAPE:
				currentChord.set_shape (new ChordShape(currentText));
		//		System.Console.WriteLine("XMLChordParser.end_element: {0}", currentChord.get_shape().to_text());
				currentText = null;
				currentState = State.CHORD;
				break;
			case State.CONSTRUCTION:
				currentChord.set_construction (new Construction(currentText));
				currentText = null;
				currentState = State.CHORD;
				break;
			case State.WRITTEN:
				currentChord.append_written(new Written(currentText));
				currentText = null;
				currentState = State.CHORD;
				break;
			case State.VOICEING:
				currentVoiceing = null;
				currentState = State.CHORD;
				break;
			case State.TUNING:
				//currentVoiceing.set
				currentText = null;
				currentState = State.VOICEING;
				break;
			case State.PRIORITY:
				currentVoiceing.set_priority(new Priority(currentText));
				currentText = null;
				currentState = State.VOICEING;
				break;
			case State.INFO:
				currentVoiceing.set_info (currentText);
				currentText = null;
				currentState = State.VOICEING;
				break;
			case State.KEY:
				currentChord.append_key(new Note(currentText));
				currentText = null;
				currentState = State.CHORD;
				break;
			case State.STRING:
				currentString = null;
				currentState = State.VOICEING;
				break;
			case State.TUNED:
				currentString.set_tuned (new Note(currentText));
				currentText = null;
				currentState = State.STRING;
				break;
			case State.FRETTED:
				currentString.set_fretted (new Note(currentText));
				currentText = null;
				currentState = State.STRING;
				break;
			case State.FRET_NO:
				currentString.set_fretNo(new FretNo(currentText));
				currentText = null;
				currentState = State.STRING;
				break;
			case State.RELATION:
				if (currentText == null){
					currentString.set_relation(new Relation("X"));
				} else {
					currentString.set_relation (new Relation(currentText));
				}	
				currentText = null;
				currentState = State.STRING;
				break;
			case State.FINGER:
				currentString.set_finger (new Finger(currentText));
				currentText = null;
				currentState = State.STRING;
				break;
			case State.OUT:
				break;
			}			
		}		
	}
}
//
//void
//my_warning (void *userData, const char *msg, ...)
//{
//	g_print(msg);
//	g_assert_not_reached();
//}
//
//void
//my_error (void *userData, const char *msg, ...)
//{
//	g_print(msg);
//	g_assert_not_reached();
//}void
//
//my_fatalError (void *userData, const char *msg, ...)
//{
//	g_print(msg);
//	g_assert_not_reached();
//}

