using System.Collections;
using System.Text;

namespace gnomeguitar_cs
{
		
	public class Voiceing {
		GuitarStringGroup strings = new GuitarStringGroup();
		string info;
		bool tuningDirty = true;
		bool relationsDirty = true;
		bool frettedsDirty = true;
		Priority priority = new Priority("0");
		Tuning tuning;
		ObjGroup relations;
		ObjGroup fretteds;
		
		public Voiceing ()
		{
		}

		public Voiceing(Tuning tuning)
		{
			foreach (Note note in tuning){
				add_string(new GuitarString(note));
			}
			set_info("");	
			this.tuning = tuning;
			tuningDirty = false;
		}

		public bool is_equal (Voiceing other)
		{
			GuitarStringGroup thesestrings;
			GuitarStringGroup otherstrings;
			bool equal;

			thesestrings = get_strings();
			otherstrings = other.get_strings();
			equal = thesestrings.is_equal_group(otherstrings);
	
			return equal; 
		}

		public Tuning get_tuning ()
		{
			Note tuned;

			if (!tuningDirty){
				return tuning;
			}
			tuning = new Tuning();
			foreach (GuitarString guitarstring in strings){
				tuned = guitarstring.get_tuned();
				tuning.append(tuned);
			}

			tuningDirty = false;

			return tuning;
		}

		public ObjGroup get_relations ()
		{
			if (!relationsDirty){
				return relations;
			}
			relations = new ObjGroup();
			foreach (GuitarString guitarstring in strings){
				relations.append(guitarstring.get_relation());
			}

			relationsDirty = false;

			return relations;
		}
		
		public ObjGroup get_fretteds ()
		{
			if (!frettedsDirty){
				return fretteds;
			}
			fretteds = new ObjGroup();
			foreach (GuitarString guitarstring in strings){
				fretteds.append(guitarstring.get_fretted());
			}

			relationsDirty = false;

			return fretteds;
		}
		public string get_tuning_text ()
		{
			return get_tuning().to_text();
		}

		public void set_priority (Priority priority)
		{
			this.priority = priority;
		}

		public Priority get_priority ()
		{
			return priority;
		}

		public void set_info (string info)
		{
			if (info == null){
				this.info = "";
			} else {	
				this.info = info;
			}
		}
		
		public string get_info ()
		{
			return info;
		}

		public void set_strings (GuitarStringGroup strings)
		{
      		this.strings = strings;
		}

		public GuitarStringGroup get_strings ()
		{
			return strings;
		}

		public void append_string (GuitarString guitarstring)
		{
			strings.append(guitarstring);
		}

		public void add_string (GuitarString guitarstring)
		{
			strings.add(guitarstring);
		}
  
		public string tuning_to_text()
		{
			return get_tuning().to_text();
		}

		public string priority_to_text()
		{
			return get_priority().to_text();
		}

		public string info_to_text()
		{
			string info;

			info = get_info();
			if (info == null){
				info = "";
			}
			return info;
		}

		public int get_no_strings ()
		{
			return strings.get_no();
		}

		public int get_noFrets ()
		{
			return get_maxFret() - get_minFret(); 
		}
	
		public int get_minFret ()
		{	
			int minFret = 100;
			FretNo fretNo;
			
			foreach(GuitarString guitarstring in strings){
				fretNo = guitarstring.get_fretNo();
				if (fretNo != -1 && fretNo < minFret){
					minFret = fretNo;
				}
			}

			if (minFret == 100){
				minFret = -1;
			}

			return minFret;
		}

		public int get_maxFret ()
		{	
			int maxFret = -1;
			int fretNo;
			
			foreach(GuitarString guitarstring in strings){
				fretNo = guitarstring.get_fretNo();
				if (fretNo != -1 && fretNo > maxFret){
					maxFret = fretNo;
				}
			}
			return maxFret;
		}
		
 		public int get_max_tuning_chars()
		{
			int maxChars = 0;
			int noChars;
			
			foreach(Note note in get_tuning()){
				noChars = note.to_text().Length;
				if (noChars > maxChars){
					maxChars = noChars;
				}
			}
			return maxChars;
		}
		
		public int get_max_relation_chars()
		{
			int maxChars = 0;
			int noChars;
			
			foreach(Relation relation in get_relations()){
				noChars = relation.to_text().Length;
				if (noChars > maxChars){
					maxChars = noChars;
				}
			}
			return maxChars;
		}
		
		public int get_max_fretted_chars()
		{
			int maxChars = 0;
			int noChars;
			
			foreach(Note note in get_fretteds()){
				noChars = note.to_text().Length;
				if (noChars > maxChars){
					maxChars = noChars;
				}
			}
			return maxChars;
		}
		
		public GuitarString get_string(int i)
		{ 
			return (GuitarString)strings.nth(i);
		}

		public string to_xml()
		{
			StringBuilder xml;

			xml = new StringBuilder("<voiceing><tuning>");
			xml.Append(get_tuning_text());
			xml.Append("</tuning><priority>");
			xml.Append(get_priority().to_text());
			xml.Append("</priority><info>");
			xml.Append(get_info());
			xml.Append("</info>");
			foreach (GuitarString guitarstring in strings){ 
				xml.Append(guitarstring.to_xml());
			}
			xml.Append("</voiceing>");

			return xml.ToString();
		}
 
		public ObjGroup get_fretNos()
		{
			ObjGroup fretNos;
		
 			fretNos = new ObjGroup();
			foreach (GuitarString guitarstring in strings){
				fretNos.append(guitarstring.get_fretNo());
			}	
			return fretNos;
		}

		public void remove_note(Note note)
		{
			Note stringNote;
			
			foreach (GuitarString guitarstring in strings){
				stringNote = guitarstring.get_fretted();
				if (stringNote == note){
					guitarstring.set_fretted(new Note(NoteValue.NO_NOTE));
				}
			}
		}
		//FIXME we need to set dirty corectly
//		void set_dirty(bool dirty)
//		{
//			tuningDirty = dirty;
//			relationsDirty = dirty;
//			frettedsDirty = dirty;
//		}
	}
}