using System.Text;
using System.Collections;

namespace gnomeguitar_cs
{	
	public class Tuning : ObjGroup
	{
		string text;
		bool clean = false;
		
		public Tuning(string text)
		{
			this.text = text;
			string[] notes = text.Split(new char[1] {','});
			foreach (string note in notes){
				Add(new Note(note));
			}
			clean=true;
		}
		public Tuning()
		{
		}

		public string to_text()
		{
			if(!clean)
			{
				//System.Console.WriteLine("Tuning.to_text: tuning was dirty when I was called");
				set_text();
			}
			return text;
		}
		
		void set_text ()
		{
			StringBuilder sb = new StringBuilder();
			int i = 0;
			foreach (Note note in this){
				if (i!=0){ sb.Append(",");}
				sb.Append(note.to_text());
				i++;
			}
			text = sb.ToString();
			clean = true;
		}
		
		public int compare(Tuning b)
		{
			return to_text().CompareTo(b.to_text());
		}
		
		public int get_max_no_chars()
		{
			int noChars = 0;
			int maxNoChars = 0;
			foreach (Note note in this){
				noChars = note.to_text().Length;
				if (noChars > maxNoChars){
					maxNoChars = noChars;
				}
			}
			return maxNoChars;
		}
		
		static public bool text_is_valid_tuning(string tuning)
		{
	
			string[] notes = tuning.Split(new char[1] {','});
			foreach (string note in notes){
				if(!Note.text_is_note(note)){
					return false;
				}
			}
			return true;
				
		}		
		
		public static bool operator == (Tuning x, Tuning y) {
			return x.to_text() == y.to_text();
		}
		
		public static bool operator != (Tuning x, Tuning y) {
			return x.to_text() != y.to_text();
		}
		
		public override bool Equals(object o) {
			if(!(o is Tuning))
				return false;
			return this == (Tuning)o;
		}
		
		public override int GetHashCode()
		{
			return to_text().GetHashCode();
		}
		
		public static implicit operator string(Tuning x) {
			return x.to_text();
		}

		override public object Clone()
		{
			//FIXME Couldn't get clone to work other ways (MeberWiseClone)
			//System.Console.WriteLine("Tuning.Clone: Tuning got cloned");
			return new Tuning(this.to_text());
		}
		
		override public void Reverse()
		{
			//System.Console.WriteLine("Tuning.Reverse: Tuning got reversed");
			base.Reverse();
			clean = false;
		}
	}
}