using System;
using GConf;

namespace gnomeguitar_cs
{
	public class ScaleRendererPrefs {
		string path = "/apps/gnome-guitar/libgnomeguitar/scaleRenderer";
		GConf.Client client;
		bool error = false;
		
		public bool Error{
			get {return error;}
		}

		bool rightHanded;
		public bool RightHanded{
			get {return rightHanded;}
			set {if (!error){client.Set(path + "/rightHanded", value);}
				rightHanded = value;}
		}
		bool highStringFirst;
		public bool HighStringFirst{
			get {return highStringFirst;}
			set {if (!error){client.Set(path + "/highStringFirst", value);}
				highStringFirst = value;}
		}
		
		string backgroundColor = "#ffffff";
		public string BackgroundColor{get {return backgroundColor;}}
				
		string borderColor = "#000000";
		public string BorderColor{get {return borderColor;}}
		double borderWidth = 2;
		public double BorderWidth{get {return borderWidth;}}
		
		string fretNoColor = "#000000";
		public string FretNoColor{get {return fretNoColor;}}
		string fretNoFont = "Times New Roman";
		public string FretNoFont{get {return fretNoFont;}}
		double fretNoPadding = 3;
		public double FretNoPadding {get {return fretNoPadding;}}		
		int fretNoSize = 10;
		public int FretNoSize{get {return fretNoSize;}}

		double fretPadding = 40;
		public double FretPadding {get {return fretPadding;}}
		
		string fretWireColor = "#000000";
		public string FretWireColor {get {return fretWireColor;}}
		double fretWireWidth = 1;
		public double FretWireWidth {get {return fretWireWidth;}}

//		string nameFont;		
//		public string TitleFont{get {return nameFont;}}
//		string nameColor;
//		public string TitleColor{get {return nameColor;}}
//		int nameSize;
//		public int TitleSize{get {return nameSize;}}
//		double namePadding;
//		public double TitlePadding {get {return namePadding;}}
		
		double neckWidth = 3;
		public double NeckWidth {get {return neckWidth;}}
		
		string noteColor = "#ff9b30";
		public string NoteColor{get {return noteColor;}}
		double noteDiameter = 15;
		public double NoteDiameter {get {return noteDiameter;}}
		
		string noteFont = "Times New Roman";
		public string NoteFont{get {return noteFont;}}
		string noteFontColor = "#000000";
		public string NoteFontColor{get {return noteFontColor;}}
		int noteFontSize = 10;
		public int NoteFontSize{get {return noteFontSize;}}
		
		string noteOutlineColor = "#d894f1";
		public string NoteOutlineColor{get {return noteOutlineColor;}}
		double noteOutlineWidth = 1;
		public double NoteOutlineWidth {get {return noteOutlineWidth;}}

		double scaleBottomPadding = 7;	
		public double ScaleBottomPadding{get {return scaleBottomPadding;}}
		double scaleLeftPadding = 7;
		public double ScaleLeftPadding{get {return scaleLeftPadding;}}
		double scaleRightPadding = 7;	
		public double ScaleRightPadding{get {return scaleRightPadding;}}
		double scaleTopPadding = 7;
		public double ScaleTopPadding{get {return scaleTopPadding;}}
		
		string stringColor = "#000000";
		public string StringColor{get {return stringColor;}}
		double stringPadding = 15;
		public double StringPadding{get {return stringPadding;}}
		double stringWidth = 1;
		public double StringWidth {get {return stringWidth;}}
		
		string tuningColor = "#000000";
		public string TuningColor{get {return tuningColor;}}
		string tuningFont = "Times New Roman";
		public string TuningFont{get {return tuningFont;}}
		double tuningPadding = 2;
		public double TuningPadding {get {return tuningPadding;}}
		int tuningSize = 10;
		public int TuningSize{get {return tuningSize;}}
		
		public delegate void PreferencesChangedHandler (object o, 
		                                                EventArgs args);
		
		public event PreferencesChangedHandler PreferencesChanged;
		
		public ScaleRendererPrefs ()
		{
			client = new GConf.Client();
			client.AddNotify (path, preferences_changed_cb);
			set_up_prefs();
		}


/***********************************************************
 ***********************PRIVATE*****************************
 ***********************************************************/

		private void set_up_prefs()
		{
			try {rightHanded = (bool)client.Get(path + "/rightHanded");} 
			catch (GConf.NoSuchKeyException){rightHanded = true; error = true;}
			try {highStringFirst = (bool)client.Get(path + "/highStringFirst");}
			catch (GConf.NoSuchKeyException){highStringFirst = true; error = true;}
//			scaleLeftPadding = (double)client.Get(path + "/scaleLeftPadding");
//			scaleRightPadding = (double)client.Get(path + "/scaleRightPadding");
//			scaleTopPadding = (double)client.Get(path + "/scaleTopPadding");
//			scaleBottomPadding = (double)client.Get(path + "/scaleBottomPadding");
//			
//			borderWidth = (double)client.Get(path + "/borderWidth");
//			borderColor = (string)client.Get(path + "/borderColor");
//		
//			backgroundColor = (string)client.Get(path + "/backgroundColor");
//			
//			stringPadding = (double)client.Get(path + "/stringPadding");
//
//			nameFont = (string)client.Get(path + "/nameFont");
//			nameColor = (string)client.Get(path + "/nameColor");
//			nameSize = (int)client.Get(path + "/nameSize");
//			namePadding = (double)client.Get(path + "/namePadding");
//			
//			fretPadding = (double)client.Get(path + "/fretPadding");
//							
//			noteOutlineWidth = (double)client.Get(path + "/noteOutline");
//			noteOutlineColor = (string)client.Get(path + "/noteOutlineColor");
//			noteColor = (string)client.Get(path + "/noteColor");
//			noteDiameter = (double)client.Get(path + "/noteDiameter");
//			noteNoFont = (string)client.Get(path + "/noteNoFont");
//			noteNoColor = (string)client.Get(path + "/noteNoColor");
//			noteNoSize = (int)client.Get(path + "/noteNoSize");
//			
//			stringWidth = (double)client.Get(path + "/stringWidth");
//			stringColor = (string)client.Get(path + "/stringColor");
//
//			tuningFont = (string)client.Get(path + "/tuningFont");
//			tuningColor = (string)client.Get(path + "/tuningColor");
//			tuningSize = (int)client.Get(path + "/tuningSize");
//			tuningPadding = (double)client.Get(path + "/tuningPadding");			
//
//			neckWidth = (double)client.Get(path + "/neckWidth");
//			fretWireWidth = (double)client.Get(path + "/fretWireWidth");
//			fretWireColor = (string)client.Get(path + "/fretWireColor");
//
//			fretNoFont = (string)client.Get(path + "/fretNoFont");
//			fretNoColor = (string)client.Get(path + "/fretNoColor");
//			fretNoSize = (int)client.Get(path + "/fretNoSize");
//			fretNoPadding = (double)client.Get(path + "/fretNoPadding");
		}

/****************************************************************
 ***********************CALLBACKS********************************
 ***************************************************************/

		void preferences_changed_cb (object sender, NotifyEventArgs args)
		{
			//System.Console.WriteLine("ScaleRendererPrefs.preferences_changed_cb: Prefs changed");
			set_up_prefs();
			if(PreferencesChanged != null){PreferencesChanged(this, new EventArgs());}
		}
	}
}