namespace gnomeguitar_cs
{
	
	
	public class Relation
	{
		string text;
		
		public Relation()
		{
		}
		public Relation(string text)
		{
			this.text = text;
		}
	
		public static bool operator == (Relation x, Relation y) {
			return x.text == y.text;
		}
		
		public static bool operator != (Relation x, Relation y) {
			return x.text != y.text;
		}
		
		public override bool Equals(object o) {
			if(!(o is Relation))
				return false;
			return this == (Relation)o;
		}
		
		public override int GetHashCode()
		{
			return text.GetHashCode();
		}
		
		public static implicit operator string(Relation x) {
			return x.text;
		}
			
		public ushort to_noteNo ()
		{
	//this function stips leading #'s and b's
	//noteNos start at 0 but relations start at 1
			ushort noteNo;
			string temp;
			
			if(text[0] == 'X'){
				return 0;
			}
			 
			temp=strip();
			
			noteNo = ushort.Parse(temp);
			return (ushort)(noteNo - 1);
		}
		
		public string strip()
		{
			ushort i = 0;
			while(text[i] == 'b'|| text[i] == '#'){
				i++;
			}
			return text.Substring(i);
		}
		
		public bool is_sharp()
		{
			return !is_double_sharp() && text.StartsWith("#");
		}
		
		public bool is_double_sharp()
		{
			return text.StartsWith("##");
		}
		
		public bool is_flat()
		{
			return !is_double_flat() && text.StartsWith("b");
		}
		
		public bool is_double_flat()
		{
			return text.StartsWith("bb");
		}
		
		public short compare(Relation b)
		{
	
			ushort aNo = to_noteNo();
			ushort bNo = b.to_noteNo();
			short val;
        //add/take away any #'s and b's
		
			if (is_double_sharp()){
				aNo += 2;
			} else if (is_sharp()) {
				aNo += 1;
			}	
			else if (is_double_flat()){
				aNo -= 2;
			} else if (is_flat()) {
				aNo -= 1;
			}
			
			if (b.is_double_sharp()){
				bNo += 2;
			} else if (b.is_sharp()) {
				bNo += 1;
			}	
			else if (b.is_double_flat()){
				bNo -= 2;
			} else if (b.is_flat()) {
				bNo -= 1;
			}
			
			if (aNo < bNo){
				val = -1;
			} else if (aNo == bNo){
				val =  0;
			} else {
				val = 1;
			}

			return val;
	
	
	}
		public void sharpen()
		{
			if (is_double_flat() || is_flat()){
				text = text.Substring(1);
			} else {
				if (is_double_sharp()){
					System.Console.WriteLine("Relation.sharpen: This shouldn't happen relation tripple sharpened");
				}
				text = "#" + text;
			}
		}

		public void flatten()
		{
			if (is_double_sharp() || is_sharp()){
				text = text.Substring(1);
			} else {
				if (is_double_flat()){
					System.Console.WriteLine("Relation.sharpen: This shouldn't happen relation tripple flattend");
				}
				text = "b" + text;
			}
		}

		public void double_sharpen()
		{
			sharpen();
			sharpen();
		}
		
		public void double_flatten()
		{
			flatten();
			flatten();
		}
		public string to_text()
		{
			return text;
		}

	}
}
