using System;
using System.Collections;

namespace gnomeguitar_cs
{
	public class ObjGroup : ArrayList{
		
		bool isThawed = true;

		public class ObjGroupEventArgs : EventArgs
		{
			public Object data;
			public Object data2;
			
			public ObjGroupEventArgs()
			{
			}
			public ObjGroupEventArgs(Object data)
			{
				this.data=data;
			}
			
			public ObjGroupEventArgs(Object data, Object data2)
			{
				this.data = data;
				this.data2 = data2;
			}
		}
		
		public delegate void ContentsChangedHandler (object objGroup, 
		                                             ObjGroupEventArgs information);
		
		public event ContentsChangedHandler onContentsChanged;
		
		public ObjGroup (): base (){ 		
		}		
		
		public ObjGroup (ArrayList list): base (list){ 
		
		
		}
		
		public ObjGroup (IList list): base (list){ 
		
		
		}
		public virtual void append (Object obj)
		{
			Add(obj);
			fire_event();
		}	

		public virtual void add (Object obj)
		{
			Add(obj);
			fire_event();
		}
		public virtual void clear ()
		{
			Clear();
			fire_event();
		}
		
		public virtual void add_by_index (Object obj, int index)
		{
			Insert(index,obj);
			fire_event();
		}

		public virtual void remove (Object obj) 
		{
			Remove(obj);
			fire_event();
		}

		public virtual void remove_by_index (int index) 
		{
			RemoveAt(index);
			fire_event();
		}
		
		public virtual void remove_all () 
		{
			Clear();
			fire_event();
		}

		public virtual Object nth(int index)
		{
			return this[index];
		}

		public virtual bool is_same_group (ObjGroup other)
		{
			return this == other;
		}

		public virtual bool is_equal_group (ObjGroup other)
		{

			if (this.Count != other.Count){
				return false;
			}

			for (int i = 0; i < this.Count; i++){
				if (this[i] != other[i]){
					return false;
				}
			}
			
			return true;
		}


		public virtual bool has_same (Object obj)
		{
			return Contains(obj);
		}
 
		public virtual bool has_equal (Object obj)
		{
			return Contains(obj);
		}	
	
		public virtual int position_same (Object obj)
		{
			return IndexOf(obj);
		}

		public virtual int position_equal (Object obj)
		{
			return IndexOf(obj);
		}
    	
		public virtual Object get_equal (Object obj)
		{
			return this[IndexOf(obj)];
		}	

		public virtual int size ()
		{
			return Count;
		}
		public virtual int get_no ()
		{
			return Count;
		}
		public void thaw(){isThawed = true;}
		public void freeze(){isThawed = false;}	

		public void fire_event()
		{
			if(onContentsChanged != null && isThawed){onContentsChanged(this, new ObjGroupEventArgs());}
		}
	}
}