
namespace gnomeguitar_cs
{
			public enum FingerValue {
			NOT_USED,
			NO_FINGER,
			INDEX,
			MIDDLE,
			RING,
			LITTLE,
			THUMB,
			UNKNOWN,
		}
	
	public class Finger
	{


		FingerValue fv;
			
		public static bool operator == (Finger x, Finger y) {
			return x.fv == y.fv;
		}
		
		public static bool operator != (Finger x, Finger y) {
			return x.fv != y.fv;
		}
		
		public override bool Equals(object o) {
			if(!(o is Finger))
				return false;
			return this == (Finger)o;
		}
		
		public override int GetHashCode()
		{
			return (int)fv;
		}
		
		public static implicit operator FingerValue(Finger x) {
			return x.fv;
		}
		
	
		public Finger()
		{
		}
		
		public Finger(FingerValue fv)
		{
			this.fv = fv;
		}
		
		public Finger(string text)
		{
			if (text == null || text == "" || text[0] == 'X'){
				fv = FingerValue.NOT_USED;
			} else if (text[0] == 'U'){
				fv = FingerValue.UNKNOWN;	    
			} else {
				ushort finger;
				finger = ushort.Parse(text);
				finger++;
				fv = (FingerValue)finger;
			}
		}
		
		public string to_text ()
		{
			string text;
	
			switch (fv){
			case FingerValue.NOT_USED: text = "None"; break;
			case FingerValue.UNKNOWN: text = "U"; break;
			case FingerValue.NO_FINGER: text = "0"; break;
			case FingerValue.INDEX: text = "1"; break;
			case FingerValue.MIDDLE: text = "2"; break;
			case FingerValue.RING: text = "3"; break;
			case FingerValue.LITTLE: text = "4"; break;
			case FingerValue.THUMB: text = "5"; break;
				default : text = null; break;
			}
			return text;
		}

		public string to_long_text ()
		{
			string text;
	
			switch (fv){
			case FingerValue.NOT_USED: text = "Not Used"; break;
			case FingerValue.UNKNOWN: text = "Unknown"; break;
			case FingerValue.NO_FINGER: text = "Not Fretted"; break;
			case FingerValue.INDEX: text = "Index"; break;
			case FingerValue.MIDDLE: text = "Middle"; break;
			case FingerValue.RING: text = "Ring"; break;
			case FingerValue.LITTLE: text = "Little"; break;
			case FingerValue.THUMB: text = "Tumb"; break;
			default: text = null; break;
			}
			return text;
		}

	
	}	
}
