using System;
using System.IO;
using System.Text;

namespace gnomeguitar_cs
{
	public class FileWriter{

		StreamWriter writer;
		bool ok = true;
		StringBuilder error;
		
		public FileWriter(string filename, bool overwrite){
			error = new StringBuilder();
			set_filename(filename, overwrite);
		}
		
		public void set_filename(string filename, bool overwrite){
			try {
				writer = new StreamWriter (filename); 
			}

			catch (DirectoryNotFoundException) { error.AppendFormat("The directory information specified in \"{0}\" was not found.", filename);
				ok = false;
			}
			catch (UnauthorizedAccessException) { error.AppendFormat("Access to \"{0}\" is denied.", filename);
				ok = false;
			}
			catch (ArgumentNullException){
				error.Append("The filename may not be null (this is probably a bug).");
				ok = false;
			}
			catch (ArgumentException) { error.Append("The filename can not be empty.");
				ok = false;
			}
			catch (System.Security.SecurityException) { error.AppendFormat("You do not have permission to accesss \"{0}\"", filename);
				ok = false;
			}
			catch (IOException) { error.AppendFormat("\"{0}\" is in an invalid format or contains invalid characters.", filename);
				ok = false;
			}
			
			if (File.Exists(filename) && !overwrite){
				error.AppendFormat("\"{0}\" allready exists, but you have specified not to overwrite it.", filename);
				ok = false;
			}			
		}
		
		public bool write(string xml){
			if(ok){
				writer.Write(xml);
				writer.Flush();
			}
			return ok;
		}
		
		public bool check()
		{
			return ok;
		}
		
		public string get_error()
		{
			return error.ToString();
		}
	}
}
