using System;
using System.IO;
using System.Text;
using System.Reflection;

namespace gnomeguitar_cs
{
	public class FileReader {
		public StreamReader reader;
		bool ok = true;
		StringBuilder error;
		
		public FileReader (ChordDb db){
			error = new StringBuilder();
			string dbResource = null;
			switch (db){
			case ChordDb.Default: dbResource = "default.gchordDb.xml"; break;
			case ChordDb.TwoChord: dbResource = "2Chord.gchordDb.xml"; break;
			case ChordDb.Simple: dbResource = "simple.gchordDb.xml"; break;
			case ChordDb.Small: dbResource = "small.gchordDb.xml"; break;
			}
			//System.Console.WriteLine("FileReader: Db = {0}, dbResource = {1}",db,dbResource);
			reader = new StreamReader(Assembly.GetExecutingAssembly().GetManifestResourceStream(dbResource));
		}			
		
		public FileReader (string filename){
			error = new StringBuilder();
			set_filename(filename);
		}			

		void set_filename(string filename){
			try {reader = new StreamReader(filename);}

			catch (DirectoryNotFoundException){
				error.AppendFormat ("The directory specified in \"{0}\" was not found.", filename);
				ok = false;
			}
			catch (FileNotFoundException){
				error.AppendFormat ("The file \"{0}\" was not found.", filename);
				ok = false;
			}
			catch (ArgumentNullException){
				error.Append("The filename may not be null (this is probably a bug).");
				ok = false;
			}
			catch (ArgumentException){
				error.Append("The filename can not be empty.");
				ok = false;
			}			catch (IOException){
				error.AppendFormat ("\"{0}\" is in an invalid format or contains invalid characters.", filename);
				ok = false;
			}	
		}
		
		public bool check()
		{
			return ok;
		}

		public string get_error()
		{
			return error.ToString();
		}
	}
}
			
