using System;
using System.Collections;
using System.Text;

namespace gnomeguitar_cs
{
	
	public class Construction : ObjGroup {

		
		public Construction()
		{
		
		}

		public Construction (ArrayList list): base(list)
		{
		
		}
	
		public Construction (string text)
		{	
			string[] relations = text.Split(new char[1]{','});
			foreach (string relation in relations){
				append(new Relation(relation));
			}
		}

		public string to_text()
		{
			StringBuilder text = new StringBuilder();
			int i = 0;
			
			foreach (Relation relation in this){
				if (i != 0){text.Append(",");}
				text.Append(relation.to_text());
				i++;
			}

			return text.ToString();
		}

		public void flatten (Relation relation)
		{
			((Relation)get_equal(relation)).flatten();
		}

		public void sharpen (Relation relation)
		{
			((Relation)get_equal(relation)).sharpen();
		}

		public void double_flatten (Relation relation)
		{
			((Relation)get_equal(relation)).double_flatten();
		}

		public void double_sharpen (Relation relation)
		{
			((Relation)get_equal(relation)).double_sharpen();
		}

		public static bool is_valid_construction(string text)
		{
			System.Console.WriteLine("FIX ME! Constrution.is_valid_construction: always returns true!");
			return true;
		}
			
/**************************************************************************
 *************************************PRIVATE STUFF************************
***************************************************************************/

//		override public void Add(Relation relation)
//		{
//			int i = 0;
//
//			foreach (Relation tempRelation in this){
//				if (relation.compare(tempRelation) == -1){
//					break;
//				}
//				i++;
//			}
//			add_by_index(relation, i);
//		}
//		
//		void add(Relation relation)
//		{
//			int i = 0;
//
//			foreach (Relation tempRelation in this){
//				if (relation.compare(tempRelation) == -1){
//					break;
//				}
//				i++;
//			}
//			add_by_index(relation, i);
//		}	
	}
}