using System;
using System.Collections;

namespace gnomeguitar_cs
{
	
	public class ChordType{
		
		string type;
		
		public static bool operator == (ChordType x, ChordType y) {
			return x.type == y.type;
		}
		
		public static bool operator != (ChordType x, ChordType y) {
			return x.type != y.type;
		}
		
		public override bool Equals(object o) {
			if(!(o is ChordType))
				return false;
			return this == (ChordType)o;
		}
		
		public override int GetHashCode()
		{
			return type.GetHashCode();
		}
		
		public ChordType(string type){
			this.type = type;
		}
		
		public string to_text(){
			return type;
		}
		
		public static implicit operator string(ChordType x) {
			return x.type;
		}
		
		public static bool is_valid(string text)
		{
			return text.Length > 0;
		}
	}
}