using System;
using System.Text;
using GConf;

namespace gnomeguitar_cs
{
	
		
	public class ChordSVGRenderer : ChordRenderer
	{
		enum Dimension {WIDTH, HEIGHT}
		
		protected ChordGroup chords;
		StringBuilder SVG = new StringBuilder("<svg></svg>");
		bool clean = true;
		string PACKAGE_VERSION = "1.0 alpah1";

		public class ChordSVGRendererEventArgs : EventArgs
		{	
			
		}
		
		public delegate void ChordsSVGRendererChangedHandler (object chordsSVGRenderer, 
		                                                      ChordSVGRendererEventArgs information);
		
		public event ChordsSVGRendererChangedHandler onSVGChanged;
		
		public ChordSVGRenderer()
		{
			
		}
		
		public ChordSVGRenderer(ChordGroup chords)
		{
			set_chords(chords);
		}
		
		public void set_chords(ChordGroup chords)
		{
			this.chords = chords;
			clean = false;
		}	
		
	
		public string render()
		{
			double chordX, chordY;
			double allChordsWidth, allChordsHeight;
			double chordWidth, chordHeight;
			
			if(clean){ return SVG.ToString();}

			SVG = new StringBuilder();
			
			chordWidth = get_chord_dimension(Dimension.WIDTH);
			chordHeight = get_chord_dimension(Dimension.HEIGHT) + (chordYPadding * 2);
			
			chordY = chordYPadding;
			chordX = chordXPadding;
			allChordsWidth = (chordWidth + chordXPadding*2) * chords.get_no();
			allChordsHeight = chordHeight;

			SVG.AppendFormat("<?xml version=\"1.0\" ?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\"\n\"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">\n<svg width=\"{0}\" height=\"{1}\">\n\t<title>Chords</title>\n\t<desc>Chords Renderered by Gnome-Chord {2}</desc>\n", allChordsWidth, allChordsHeight, PACKAGE_VERSION);
			append_SVG_style();
			foreach (Chord chord in chords){
				append_SVG_chord(chord, chordX, chordY);
				chordX += (chordXPadding * 2) + chordWidth;
			}
			SVG.Append("</svg>\n");
			clean=true;
			
			return SVG.ToString();
		}	

/***********************************************************
 ***********************PRIVATE*****************************
 ***********************************************************/

		void append_SVG_style()
		{
	
			SVG.Append("<defs>\n<style type=\"text/css\"><![CDATA[\n");
			SVG.AppendFormat("\t.border {\n\tfill: #FFFFFF; \n\tstroke: {0};\n\tstroke-width: {1}\n\t}\n", borderColor, borderWidth);
			SVG.AppendFormat("\t.title {\n\tfill: {0};\n\tfont-family: {1};\n\tfont-size: {2}pt;\n\ttext-anchor: middle\n\t}\n",
				     titleColor, titleFont, titleSize);
			SVG.AppendFormat("\t.tuning {\n\tfill: {0};\n\tfont-family: {1};\n\tfont-size: {2}pt;\n\ttext-anchor: middle\n\t}\n",
				     tuningColor, tuningFont, tuningSize);
			SVG.AppendFormat("\t.neck {\n\tstroke: {0};\n\tstroke-width: {1}\n\t}\n",
				    neckColor, neckWidth);
			SVG.AppendFormat("\t.fret {\n\tstroke: {0};\n\tstroke-width: {1}\n\t}\n", 
					fretWireColor, fretWireWidth);
			SVG.AppendFormat("\t.fretNo {\n\tfill: {0};\n\tfont-family: {1};\n\tfont-size: {2}pt;\n\ttext-anchor: middle\n\t}\n",
				      fretNoColor, fretNoFont, fretNoSize);
			SVG.AppendFormat("\t.guitarString {\n\tstroke: {0};\n\tstroke-width: {1}\n\t}\n",
				      stringColor, stringWidth);
			SVG.AppendFormat("\t.relation {\n\tfill: {0};\n\tfont-family: {1};\n\tfont-size: {2}pt;\n\ttext-anchor: middle\n\t}\n",
					relationColor, relationFont, relationSize);
			SVG.AppendFormat("\t.fingerNo {\n\tfill: {0};\n\tfont-family: {1};\n\tfont-size: {2}pt;\n\ttext-anchor: middle\n\t}\n",
					  fingerFontColor, fingerFont, fingerFontSize);
			SVG.AppendFormat("\t.finger {\n\tfill: {0};\n\t}\n", 
				      fingerColor);
			SVG.AppendFormat("\t.fretted {\n\tfill: {0};\n\tfont-family: {1};\n\tfont-size: {2}pt;\n\ttext-anchor: middle\n\t}\n",
				     frettedColor, frettedFont, frettedSize);
			SVG.AppendFormat("\t.dashed {\n\tstroke-dasharray: 2.5, 2.5;\n\t}\n");
			SVG.AppendFormat("]]></style>\n</defs>\n");
		}


		double get_chord_dimension(Dimension dimension)
		{
//			double commonSize;
			double size;

			if(dimension == Dimension.WIDTH){
				size = voiceingLeftPadding + voiceingRightPadding;
			} else {
				size = titleSize + titlePadding + voiceingTopPadding + voiceingBottomPadding + (borderWidth * 2);
			}
	
			size += get_voiceing_dimension(dimension);

			return size;
		}
	
		double get_voiceing_dimension(Dimension dimension)
		{
			double size = 0;
			//Fixme this won't work if we have a differnt no strings
			int noStrings = 5;
	
			if (dimension == Dimension.WIDTH && (chordRotation == ChordRotation.Vertical)){
				size = ((stringGap * noStrings) + (fretNoPadding + (fretNoSize * 2)) * 2);
			} else if (dimension == Dimension.HEIGHT && (chordRotation == ChordRotation.Horizontal)) {
				size = (stringGap * noStrings) + ((fretNoPadding + fretNoSize) * 2);
			} else if (dimension == Dimension.HEIGHT && (chordRotation == ChordRotation.Vertical)) {
				int maxNoFrets;
		
				maxNoFrets = chords.get_max_no_frets();
		
				if (maxNoFrets < minNoFrets){
					maxNoFrets = minNoFrets;
				}
	
				size = tuningSize
					+ tuningPadding
						+ (fretGap * (maxNoFrets -1))
						+ (stringExtraPercent * fretGap)
						+ relationPadding
						+ relationSize
						+ frettedPadding
						+ frettedSize;
			} else {
				int maxNoFrets;
		
				maxNoFrets = chords.get_max_no_frets();
			
				if (maxNoFrets < minNoFrets){
					maxNoFrets = minNoFrets;
				}
	
				size = (tuningSize * 2)
					+ tuningPadding
						+ (fretGap * (maxNoFrets -1))
						+ (stringExtraPercent * fretGap)
						+ relationPadding
						+ (relationSize * 2)
						+ frettedPadding
						+ (frettedSize * 3);
			}	
	    
			return size;
		}
	
		void append_SVG_chord (Chord chord, double X, double Y)
		{
			double voiceingHeight, voiceingWidth;
//			int noVoiceings;
			double titleX, titleY;
	
//			string borderSVG;
//			string nameSVG;
//			string voiceingSVG;
//			StringBuilder chordSVG = new StringBuilder();
	
			double borderX, borderY, borderWidth, borderHeight;
			double voiceingX, voiceingY;
	
//			Voiceing voiceing;

			voiceingWidth = get_voiceing_dimension(Dimension.WIDTH);
			voiceingHeight = get_voiceing_dimension(Dimension.HEIGHT);

//			noVoiceings = chord.get_noVoiceings();

			borderX = X;
			borderY = Y;
			borderWidth = (voiceingWidth + voiceingLeftPadding + voiceingRightPadding);
			borderHeight = titlePadding + titleSize + voiceingHeight 
				+ voiceingTopPadding + voiceingBottomPadding;
	
			SVG.AppendFormat("<rect class=\"border\" x=\"{0}\" y=\"{1}\" width=\"{2}\" height=\"{3}\" />\n",
			                      borderX, borderY, borderWidth, borderHeight);
	
			titleX = (borderWidth / 2) + X;
			titleY = borderY + titlePadding + titleSize;

			append_SVG_chordName (chord, titleX, titleY);
	
			voiceingX = X + voiceingLeftPadding;
			voiceingY = titleY + voiceingTopPadding;

			append_SVG_voiceing (chord.get_voiceing(0), voiceingX, voiceingY);
		}

		void append_SVG_chordName(Chord chord, double centerX, double centerY)
		{
			SVG.AppendFormat("<text class=\"title\" x=\"{0}\" y=\"{1}\">{2}</text>\n", 
			                 centerX, centerY, chord.get_name());
		}

		void append_SVG_voiceing (Voiceing voiceing, double X, double Y)
		{
//			string[] SVGFrets;
//			string SVGTempFret;
//			string SVGAllFrets;
//			string tempString;
//			string[] SVGGuitarStrings;
//			string SVGAllGuitarStrings;
	
			int minFret, noFrets, startFret;
			string fretClass;
			double fretLength = 0;
			double fretX1 = 0, fretY1 = 0, fretX2 = 0, fretY2 = 0;
			int i = 0;
//			int j = 0;
			int fretNo = 0;
			int noStrings = 0;
			double fretNoX = 0, fretNoY = 0;

			double tuningX = 0, tuningY = 0;

			//this is needed as we changed it
			int startFretPadding = 0;

//******************************************************************
//************************FRET STUFF********************************
//******************************************************************

			minFret = voiceing.get_minFret(); 
	
			while ( minFret - startFretPadding < 0){
				startFretPadding--;
			}
			
			noFrets = voiceing.get_noFrets()
				+ startFretPadding
					+ endFretPadding;

			startFret = minFret - startFretPadding;

			if (noFrets < minNoFrets){
				noFrets = minNoFrets;
			}

			noStrings = voiceing.get_no_strings();
	
			fretLength = stringGap * (noStrings - 1);
	
	//Note this gives us the position of fret 0
			if (chordRotation == ChordRotation.Vertical){
				fretX1 = X + (fretNoSize*2) + fretNoPadding;
				fretX2 = fretX1 + fretLength;
				fretY1 = Y + tuningSize + tuningPadding;
				fretY2 = fretY1;
			} else {
//			case 90:
//				fretX1 = X + (relationSize*2) + relationPadding
//					+ (frettedSize*3) + frettedPadding
//						+ (stringExtraPercent * fretGap)
//						+ (fretGap * (noFrets -1));
//				fretY1 = Y + fretNoSize + fretNoPadding;
//				fretX2 = fretX1;
//				fretY2 = fretY1 + fretLength;
//				break;
//			case 180:
//				fretX2 = X + (fretNoSize*2) + fretNoPadding;
//				fretY1 = Y + relationSize + relationPadding
//					+ frettedSize + frettedPadding
//						+ (stringExtraPercent * fretGap)
//						+ (fretGap * (noFrets -1));
//				fretX1 = fretX2 + fretLength;
//				fretY2 = fretY1;
//				break;
				fretX1 = X + (tuningSize*2) + tuningPadding;
				fretY1 = Y + fretNoSize + fretNoPadding + fretLength;
				fretX2 = fretX1;
				fretY2 = fretY1 - fretLength;
			}


			for (i = 0, fretNo = startFret; i < noFrets; i++, fretNo++){
				if (i == 0 && minFret == 0){
					fretClass = "neck";
				} else {
					fretClass = "fret";
				}

				if(chordRotation == ChordRotation.Vertical){
					fretNoX = fretX2 + fretNoPadding + fretNoSize;
					fretNoY = fretY1 + (fretNoSize / 2);
				} else {
//				case 180:
//					fretNoX = fretX2 - fretNoPadding - fretNoSize;
//					fretNoY = fretY1 + (fretNoSize / 2);
//					break;
//				case 90:
//					fretNoX = fretX2;
//					fretNoY = fretY2 + fretNoPadding + (fretNoSize *1.5);
//					break;
					fretNoX = fretX2;
					fretNoY = fretY2 - fretNoPadding;
				}

				SVG.AppendFormat("<line class=\"{0}\" x1=\"{1}\" y1=\"{2}\" x2=\"{3}\" y2=\"{4}\" />\n<text class=\"fretNo\" x=\"{5}\" y=\"{6}\">{7}</text>\n", fretClass, fretX1, fretY1, fretX2, fretY2, fretNoX, fretNoY, fretNo); 

				switch (chordRotation){
				case 0:
					fretY1 += fretGap;
					fretY2 += fretGap;
					break;
				case 180:
					fretY1 -= fretGap;
					fretY2 -= fretGap;
					break;
				case 90:
					fretX1 -= fretGap;
					fretX2 -= fretGap;
					break;
				case 270:
					fretX1 += fretGap;
					fretX2 += fretGap;
					break;
				}
			}
			
//******************************************************************************
//************************STRING STUFF******************************************
//******************************************************************************
	
			switch (chordRotation){
			case 0:  
				tuningX = X + (fretNoSize*2) + fretNoPadding;
				tuningY = Y + tuningSize;
				break;
			case 90:
				tuningX = X + get_voiceing_dimension(Dimension.WIDTH) - tuningSize;
				tuningY = Y + fretNoSize + fretNoPadding + (tuningSize/2);
				break;
			case 180:
				tuningX = X + get_voiceing_dimension(Dimension.WIDTH) 
					- (fretNoSize*2) - fretNoPadding;
				tuningY = Y + get_voiceing_dimension(Dimension.HEIGHT);
				break;
			case 270:
				tuningX = X + (tuningSize);
				tuningY = Y + get_voiceing_dimension(Dimension.HEIGHT) 
					- fretNoSize - fretNoPadding 
						+ (tuningSize/2);
				break;
			}
			
			foreach (GuitarString guitarString in voiceing.get_strings()) {
				append_SVG_guitarString(guitarString, noFrets, startFret, tuningX, tuningY);
				switch(chordRotation){
				case 0:	  tuningX += stringGap; break;	
				case 90:  tuningY += stringGap; break;
				case 180: tuningX -= stringGap; break;
				case 270: tuningY -= stringGap; break;
				}
		
			}
		}

		void append_SVG_tuning (GuitarString guitarString, double x, double y)
		{
			SVG.AppendFormat("<text class=\"tuning\" x=\"{0}\" y=\"{1}\">",x,y);
			SVG.Append(guitarString.get_tuned().to_text());
			SVG.Append("</text>\n");
		}
	
		void append_SVG_guitarString(GuitarString guitarString,
		                             int noFrets,
		                             int startFret,
		                             double tuningX,
		                             double tuningY)
		{
			String SVGClass;
			double stringLength = 0;
			double stringX1 = 0, stringY1 = 0, stringX2 = 0, stringY2 = 0;

			SVG.Append("<g>\n");	
			append_SVG_tuning(guitarString, tuningX, tuningY);

			stringLength = ((noFrets - 1)* fretGap) 
				+ (fretGap * stringExtraPercent);

			switch(chordRotation){
			case 0:
				stringX1 = tuningX;
				stringY1 = tuningY + tuningPadding;
				stringX2 = stringX1;
				stringY2 = stringY1 + stringLength;
				break;
			case 90: 
				stringX1 = tuningX - tuningSize -tuningPadding;
				stringY1 = tuningY - (tuningSize/2);
				stringX2 = stringX1 - stringLength;
				stringY2 = stringY1;
				break;
			case 180:
				stringX1 = tuningX ;
				stringY1 = tuningY - tuningSize - tuningPadding;
				stringX2 = stringX1;
				stringY2 = stringY1 - stringLength;
				break;
			case 270:
				stringX1 = tuningX + tuningSize + tuningPadding;
				stringY1 = tuningY - (tuningSize/2);
				stringX2 = stringX1 + stringLength;
				stringY2 = stringY1;
				break;
			}

			if (guitarString.played()){
				SVGClass = "";
			} else {
				SVGClass = "dashed";
			}
 	
			SVG.AppendFormat("<line class=\"guitarString {0}\" x1=\"{1}\" y1=\"{2}\" x2=\"{3}\" y2=\"{4}\" />\n", SVGClass, stringX1, stringY1, stringX2, stringY2);
	
			append_SVG_frettedNRelation(guitarString,
			                            stringX1, stringY1,
			                            stringX2, stringY2);
	
			append_SVG_finger(guitarString, startFret, stringX1, stringY1);
			SVG.Append("</g>\n"); 
		}
	
		void append_SVG_finger(GuitarString guitarString,
		                       int startFret,
		                       double stringX1, double stringY1)
		{
			double fingerCenterX = 0, fingerCenterY = 0;

			if (guitarString.played() 
			    && guitarString.get_fretNo() != 0){
//				string fingerNoText;
				double fingerRadius = 0;
				double fingerTextX = 0, fingerTextY = 0;
		
				double fingerPosition = 
					(fretGap * (guitarString.get_fretNo() - startFret))
						- (fretGap /2);
		
				switch(chordRotation){
				case 0:  fingerCenterX = stringX1;
					fingerCenterY = stringY1 + fingerPosition;
					break;
				case 90: fingerCenterX = stringX1 - fingerPosition;
					fingerCenterY = stringY1;
					break;
				case 180:fingerCenterX = stringX1;
					fingerCenterY = stringY1 - fingerPosition;
					break;
				case 270:fingerCenterX = stringX1 + fingerPosition;
					fingerCenterY = stringY1;
					break;
				}
		
				fingerRadius = fingerDiameter/2;		
				fingerTextX = fingerCenterX;
				
				switch (chordRotation){
				case 0:  fingerTextY = fingerCenterY + (fingerFontSize / 2); break;
				case 270: fingerTextY = fingerCenterY + (fingerFontSize / 2); break;
				case 90:  fingerTextY = fingerCenterY + (fingerFontSize /2); break;
				case 180: fingerTextY = fingerCenterY + (fingerFontSize /2); break;
				}
		
				SVG.AppendFormat("<circle class=\"finger\" cx=\"{0}\" cy=\"{1}\" r=\"{2}\"/>\n<text class=\"fingerNo\" x=\"{3}\" y=\"{4}\">{5}</text>\n",
				                 fingerCenterX, fingerCenterY, fingerRadius, fingerTextX, fingerTextY,
				                 guitarString.get_finger().to_text());
			}
		}

		void append_SVG_frettedNRelation(GuitarString guitarString,
		                                 double stringX1, double stringY1,
		                                 double stringX2, double stringY2)
		{
			string frettedText;
			string relationText;
			double relationX = 0, relationY = 0, frettedX = 0, frettedY = 0;
			
			frettedText = guitarString.get_fretted().to_text();
			relationText = guitarString.get_relation().to_text();
	
			switch(chordRotation){
			case 0:  frettedX = stringX1;
				frettedY = stringY2 + frettedPadding + frettedSize;
				break;
			case 90: frettedX = stringX2 - frettedPadding - (frettedSize*1.5);
				frettedY = stringY1 + (frettedSize/2);
				break;
			case 180:frettedX = stringX1;
				frettedY = stringY2;
				break;
			case 270:frettedX = stringX2 + frettedPadding + (frettedSize*1.5);
				frettedY = stringY1 + (frettedSize/2);
				break;
			}
	
			switch(chordRotation){
			case 0:  relationX = frettedX;
				relationY = frettedY + relationPadding + relationSize;
				break;
			case 90: relationX = frettedX - (frettedSize*1.5) 
				- relationPadding - relationSize;
				relationY = frettedY;
				break;
			case 180:relationX = frettedX;
				relationY = frettedY - frettedSize - relationPadding;
				break;
			case 270:relationX = frettedX + (frettedSize*1.5)
				+ relationPadding + relationSize;
				relationY = frettedY;
				break;
			}
	
			SVG.AppendFormat("<text class=\"fretted\" x=\"{0}\" y=\"{1}\">{2}</text>\n<text class=\"relation\" x=\"{3}\" y=\"{4}\">{5}</text>\n", frettedX, frettedY, frettedText, relationX, relationY, relationText);
		} 

		public void GConf_Changed (object sender, NotifyEventArgs args)
		{
			clean=false;
			render();
			if(onSVGChanged != null){onSVGChanged(this, new ChordSVGRendererEventArgs());}
		}
	}
}