using System;
using System.Collections;
using System.Text;

namespace gnomeguitar_cs
{
	
	public class ChordGroup : ObjGroup{

//		Note[] interestingChords = new Note[18] {new Note(NoteValue.Ab),
//				new Note(NoteValue.A), new Note(NoteValue.A_SHARP),
//				new Note(NoteValue.Bb), new Note(NoteValue.B),
//				new Note(NoteValue.C), new Note(NoteValue.C_SHARP),
//				new Note(NoteValue.Db), new Note(NoteValue.D),
//				new Note(NoteValue.D_SHARP), new Note(NoteValue.Eb),
//				new Note(NoteValue.E), new Note(NoteValue.F),
//				new Note(NoteValue.F_SHARP), new Note(NoteValue.Gb),
//				new Note(NoteValue.G), new Note(NoteValue.G_SHARP)
//			};
		Note[] interestingChords = {new Note(NoteValue.Ab),
				new Note(NoteValue.A), new Note(NoteValue.A_SHARP),
				new Note(NoteValue.Bb), new Note(NoteValue.B),
				new Note(NoteValue.C), new Note(NoteValue.C_SHARP),
				new Note(NoteValue.Db), new Note(NoteValue.D),
				new Note(NoteValue.D_SHARP), new Note(NoteValue.Eb),
				new Note(NoteValue.E), new Note(NoteValue.F),
				new Note(NoteValue.F_SHARP), new Note(NoteValue.Gb),
				new Note(NoteValue.G), new Note(NoteValue.G_SHARP)
			};

		public ChordGroup (): base () 
		{
			
		}

		public ChordGroup (Chord[] chords)
		{ 
			freeze();
			foreach (Chord chord in chords){
				add(chord);
			}
			thaw();
		}
		public ChordGroup (Object[] chords)
		{ 
			freeze();
			foreach (Object chord in chords){
				add(chord as Chord);
			}
			thaw();
		}
//		public ChordGroup (ArrayList chords)
//		{ 
//			this.chords = chords;
//		}
//		public void add(Chord chord){
//			add((Object)chord);
//		}
		
		public ObjGroup get_text()
		{
			ObjGroup textList = new ObjGroup();
			
			foreach (Chord chord in this){
				textList.add(chord.get_text());
			}
			return textList;
		}

		public virtual ChordGroup create_type_sub_group (ChordType type)
		{
			ChordGroup newChordGroup;
					
			if(type == "Any"){
				return this;
			}

			newChordGroup = new ChordGroup();
			foreach (Chord chord in this){
				//we got rid of a null compare which might be needed for the chordCreator
				if (chord.compare_type(type)){
					newChordGroup.add(chord);
				}
			}
	
			return newChordGroup;
		}
	

		public virtual ChordGroup create_root_sub_group (Note root)
		{
			ChordGroup newChordGroup;
	
			if (root == NoteValue.ANY){
				return this;
			}

			newChordGroup = new ChordGroup();
			foreach (Chord chord in this){
				if (root == NoteValue.NO_NOTE || chord.compare_root(root)){
					newChordGroup.add(chord);
				}
			}

			return newChordGroup;
		}

		public virtual ChordGroup create_key_sub_group (Note key)
		{
			ChordGroup newChordGroup;

			newChordGroup = new ChordGroup();
			foreach (Chord chord in this){
				if (key == NoteValue.NO_NOTE || chord.has_key(key)){
					newChordGroup.add(chord);
				}
			}
			return newChordGroup;
		}
	
		public virtual ChordGroup create_shape_sub_group (ChordShape shape)
		{
			ChordGroup newChordGroup;
	
			if(shape == ChordShapeValue.ANY){
				return this;
			}

			newChordGroup = new ChordGroup();
			foreach (Chord chord in this){
				if (shape == ChordShapeValue.NO_SHAPE || chord.compare_shape(shape)){
					newChordGroup.add(chord);
				}
			}

			return newChordGroup;
		}

		public virtual ChordGroup create_tuning_sub_group (Tuning tuning)
		{
			ChordGroup newChordGroup;

			newChordGroup = new ChordGroup();
			foreach (Chord chord in this){
				if (tuning.to_text() == null || chord.compare_tuning(tuning)){
					newChordGroup.add(chord);
				}
			}
			return newChordGroup;
		}

		public virtual ChordGroup create_sub_group(ChordType type,
		                            Note root,	
		                            Note key,
		                            ChordShape shape)
		{
			ChordGroup temp;
			ChordGroup temp2;

			temp = create_type_sub_group (type);
			temp2 = temp.create_root_sub_group (root);
			temp = temp2.create_key_sub_group (key);
			temp2 = temp.create_shape_sub_group (shape);

			return temp2;
		}


		public ChordGroup create_numbered_sub_group(int start, int end)
		{
			IEnumerator iter;
			ChordGroup chords = new ChordGroup();
			
			iter = GetEnumerator(start, 1 + (end - start));
			while (iter.MoveNext()){
				chords.append(iter.Current as Chord);
			}
			
			return chords;
		}

		

		public ObjGroup get_chordTypes()
		{
			ObjGroup types = new ObjGroup();
			ChordType type;
			
			foreach (Chord chord in this){
				type = chord.get_chordType();
				if (!types.Contains(type)){
					types.add(type);
				}
			}

			return types;
		}

		public ObjGroup get_chordShapes()
		{
			ObjGroup shapes = new ObjGroup();
			ChordShape shape;
			
			foreach (Chord chord in this){
				shape = chord.get_shape();
				if (!shapes.Contains(shape)){
					shapes.add(shape);
				}
			}
			return shapes;
		}
		
		public NoteGroup get_roots()
		{
			NoteGroup roots = new NoteGroup();
			Note root;
			
			foreach (Chord chord in this){
				root = chord.get_root();
				if (!roots.Contains(root)){
					roots.add(root);
				}
			}
			return roots;
		}

		public void add_chordType(ChordType type)
		{
			freeze();
			foreach (ChordShapeValue csv in ChordShape.chordShapeValues){
				if (csv == ChordShapeValue.NO_SHAPE){continue;}
				foreach (Note note in interestingChords){
					add(new Chord(type, note, new ChordShape(csv)));
				}
			}
			thaw();
			fire_event();
		}


		public void add_tuning(ChordType type, Tuning tuning)
		{
			freeze();
			foreach (ChordShapeValue csv in ChordShape.chordShapeValues){
				if (csv == ChordShapeValue.NO_SHAPE){continue;}
				foreach (Note note in interestingChords){
					add(new Chord(type, tuning, note, new ChordShape(csv)));
				}
			}
			thaw();
			fire_event();
		}

		public TuningGroup get_tunings()
		{
			TuningGroup tunings  = new TuningGroup();
			Tuning tuning;
			
			foreach (Chord chord in this){
				tuning = chord.get_tuning();
				if (!tunings.Contains(tuning)){
					tunings.Add(tuning);
				}
			}
			return tunings;
		}

		
		public string to_xml()
		{
			StringBuilder xml = new StringBuilder("<chords version=\"1.0\">");
	
			foreach (Chord chord in this){
				xml.Append(chord.to_xml());
			}
			xml.Append("</chords>");
			return xml.ToString();
		}


		public Chord merge_chord(Chord chord)
		{
			//No idea what the point of all this is
			Chord realChord;
			Voiceing voiceing;
	
			int chordPosition = position_equal(chord);

			if(chordPosition != -1){
				realChord = (Chord)nth(chordPosition);
				voiceing = chord.get_voiceing(0);
				if(!realChord.has_equal_voiceing(voiceing)){
					realChord.add_voiceing(voiceing);
				}
			} else {
				add(chord);
				realChord = chord;
			}
	
			return realChord;
		}
		
		//FIXME WE REALY SHOULD GET ALL THE MAX VALUES AT ONCE

		public int get_max_tuning_chars()
		{
			int maxNoChars = 0;
			int noChars;

			foreach (Chord chord in this){
				noChars = chord.get_max_tuning_chars();
				if(noChars > maxNoChars){
					maxNoChars = noChars;
				}
			}

			return maxNoChars;
		}
		
		public int get_max_relation_chars()
		{
			int maxNoChars = 0;
			int noChars;

			foreach (Chord chord in this){
				noChars = chord.get_max_relation_chars();
				if(noChars > maxNoChars){
					maxNoChars = noChars;
				}
			}

			return maxNoChars;
		}		
		
		public int get_max_fretted_chars()
		{
			int maxNoChars = 0;
			int noChars;

			foreach (Chord chord in this){
				noChars = chord.get_max_fretted_chars();
				if(noChars > maxNoChars){
					maxNoChars = noChars;
				}
			}

			return maxNoChars;
		}
		
		public int get_max_no_frets()
		{
			int maxNoFrets = 0;
			int noFrets;

			foreach (Chord chord in this){
				noFrets = chord.get_max_no_frets();
				if(noFrets > maxNoFrets){
					maxNoFrets = noFrets;
				}
			}

			return maxNoFrets;
		}
		
		public int get_max_no_strings()
		{
			int maxNoStrings = 0;
			int noStrings;

			foreach (Chord chord in this){
				noStrings = chord.get_max_no_strings();
				if(noStrings > maxNoStrings){
					maxNoStrings = noStrings;
				}
			}

			return maxNoStrings;
		}

		public virtual ChordGroup create_scale_sub_group (Scale scale)
		{
			ChordGroup newChordGroup;
	
			newChordGroup = new ChordGroup();
			foreach(Chord chord in this){
				if (chord.good_for_scale(scale)){
					newChordGroup.add(chord);
				}
			}
	
			return newChordGroup;
		}

	}
}