/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef PLAYER_H
#define PLAYER_H

#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>

extern "C"
{
	#include <xine.h>
}

class Player : public QThread
{
	public:
		Player();
		~Player();

		void setTrack(const QString & t);
		void setVolume(const int & vol);
		void setPos(const int & p);
		void setEqualizer(const int & amp, const int freq[]);
		void setSoundSystem(const QString & system);

		int getLength() const;
		int getVolume() const;
		int getPos() const;
		QString getTrack() const;
		QStringList getAudioCDContents(const QString & device) const;
		const xine_t * getXineHandle() const;
		const xine_stream_t * getXineStreamHandle() const;
		QString getXineVer() const;

		void run();

		void termThread();
		void wakeThread();

	private:
		QString xineVer;
		QString track;
		bool term;

		int volume;
		int length;
		int pos;

		xine_t            * xine;
		xine_stream_t     * stream;
		xine_audio_port_t * ao_port;
};

#endif
