#!/bin/sh

###
## functions
###
function chk_qmake_ver()
{
	VER=$(cat ./Makefile | awk '
	{
		if (NR==3)
			print substr($7, 0, 3);
	}')

	if [ "$VER" == "3.3" ]
	then
		return 0
	else
		return 1
	fi
}

###
## constants
###
QT_ALT_PATH=("$QTDIR/bin" "/lib/qt3/bin" "/usr/lib/qt3/bin" "/usr/local/lib/qt3/bin")
KDE_PREFIX=$(kde-config --prefix)
ICONS_DIR="share/icons/default.kde"
LINK_DIR="share/applnk/Multimedia"
SMNU_DIR="share/apps/konqueror/servicemenus"
TRANSLATIONS=("pl" "it" "es" "nl" "zh_CN" "cs" "ru" "uk")

###
## build
###
echo -e "\E[0;32m>> \E[0;36mcompiling source code...\E[0;38m"
qmake
chk_qmake_ver
if [ $? -ne 0 ]
then
	for i in ${QT_ALT_PATH[@]}
	do
		$("$i/qmake")
		chk_qmake_ver
		if [ $? -eq 0 ]
		then
			break
		fi
	done
fi
make >> /dev/null
strip bin/falf --strip-all

###
## kde-config
###
if [ "$KDE_PREFIX" == "" ]
then
	echo "kde-config not present, exiting."
	exit 1
fi

###
## install
###
echo -e "\E[0;32m>> \E[0;36minstalling binaries...\E[0;38m"
cp -f bin/falf "$KDE_PREFIX/bin/"

for i in ${TRANSLATIONS[@]}
do
	msgfmt "po/$i/falf.po" -o "$KDE_PREFIX/share/locale/$i/LC_MESSAGES/falf.mo"
done

echo -e "\E[0;32m>> \E[0;36minstalling icons...\E[0;38m"
cp -Rf icons/* "$KDE_PREFIX/$ICONS_DIR/"

echo -e "\E[0;32m>> \E[0;36minstalling links...\E[0;38m"
if [ ! -d "$KDE_PREFIX/$LINK_DIR/" ]; then
	mkdir "$KDE_PREFIX/$LINK_DIR/"
fi
cp -f applnk/falf.desktop "$KDE_PREFIX/$LINK_DIR/"
cp -f applnk/falf_mnu.desktop "$KDE_PREFIX/$SMNU_DIR/"

echo -ne "\E[0;0m"
