/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <klocale.h>

void frmAccels::init()
{
	setCaption(i18n("Accelerators"));
	pshCancel->setText(i18n("Cancel"));
	pshDefault->setText(i18n("Default"));

	list = new AccelView(this);
	list->setGeometry(0, 0, (geometry().width() - 99), geometry().height());
	list->addColumn(i18n("Action"));
	list->addColumn(i18n("Accelerator"));

	connect(list, SIGNAL(accelChanged()), this, SLOT(unique()));

	uniqueCheck = true;
}

void frmAccels::addItem(const QString & name, const QKeySequence & accel)
{
	(new AccelViewItem(list, name, accel))->moveItem(list->lastChild());
}

AccelViewItem * frmAccels::item(int i)
{
	return (AccelViewItem *)list->itemAtIndex(i);
}

void frmAccels::unique()
{
	if (!uniqueCheck)
		return;

	for (unsigned int i = 0 ; i != itemCount() ; i++)
	{
		for (unsigned int j = 0 ; j != itemCount() ; j++)
		{
			if (i == j)
				continue;

			AccelViewItem * ii = (AccelViewItem *)list->itemAtIndex(i);
			AccelViewItem * jj = (AccelViewItem *)list->itemAtIndex(j);

			if (ii->accel() == jj->accel())
			{
				ii->setAccel(QKeySequence());
				jj->setAccel(QKeySequence());
			}
		}
	}
}

void frmAccels::acceptAccels()
{
	ok = true;

	hide();
}

void frmAccels::rejectAccels()
{
	ok = false;

	hide();
}

void frmAccels::defaults()
{
	int def[] =
		{
			CTRL+Key_G,
			CTRL+Key_H,
			CTRL+Key_P,
			CTRL+Key_N,
			CTRL+Key_T,
			CTRL+Key_Up,
			CTRL+Key_Down,
			Key_Delete,
			CTRL+Key_Right,
			CTRL+Key_O,
			CTRL+Key_D,
			CTRL+Key_C,
			CTRL+Key_U,
			CTRL+Key_Z,
			CTRL+Key_X,
			CTRL+Key_Y,
			CTRL+Key_K,
			CTRL+Key_S,
			CTRL+Key_R,
			CTRL+Key_F,
			CTRL+Key_E,
			CTRL+Key_L,
			CTRL+Key_V,
			CTRL+Key_B,
			CTRL+Key_A,
			SHIFT+Key_C,
			SHIFT+Key_S,
			SHIFT+Key_A,
			Key_Plus,
			Key_Minus,
			Key_Left,
			Key_Right,
			CTRL+Key_Comma,
			CTRL+Key_Period,
			CTRL+Key_Slash,
			CTRL+Key_Q
		}; // 36

	uniqueCheck = false;

	for (unsigned int i = 0 ; i != itemCount() ; i++)
		((AccelViewItem *)list->itemAtIndex(i))->setAccel(def[i]);

	uniqueCheck = true;
}

unsigned int frmAccels::itemCount()
{
	return list->childCount();
}

AccelView * frmAccels::accelView()
{
	return list;
}
