/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * ITextFontMetricsFactory.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.itext;

import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.merge.CompoundFontIdentifier;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontIdentifier;
import com.lowagie.text.pdf.BaseFont;

/**
 * Todo: Document me!
 *
 * @author : Thomas Morgner
 */
public class ITextFontMetricsFactory implements FontMetricsFactory
{
  private BaseFontSupport baseFontSupport;
  
  public ITextFontMetricsFactory(final ITextFontRegistry registry)
  {
    this.baseFontSupport = new BaseFontSupport(registry);
  }

  public void close()
  {
    this.baseFontSupport.close();
  }
  
  public FontMetrics createMetrics(final FontIdentifier identifier,
                                   final FontContext context)
  {
    final CompoundFontIdentifier compoundFontIdentifier;
    final FontIdentifier record;
    if (identifier instanceof CompoundFontIdentifier)
    {
      compoundFontIdentifier = (CompoundFontIdentifier) identifier;
      record = compoundFontIdentifier.getIdentifier();
    }
    else
    {
      record = identifier;
      compoundFontIdentifier = null;
    }

    final String fontName;
    final boolean bold;
    final boolean italic;
    if (record instanceof FontRecord)
    {
      final FontRecord fontRecord = (FontRecord) record;
      fontName = fontRecord.getFamily().getFamilyName();
      if (compoundFontIdentifier != null)
      {
        bold = compoundFontIdentifier.isBoldSpecified();
        italic = compoundFontIdentifier.isItalicsSpecified();
      }
      else
      {
        bold = fontRecord.isBold();
        italic = fontRecord.isItalic();
      }
    }
    else if (record instanceof TrueTypeFontIdentifier)
    {
      final TrueTypeFontIdentifier ttfFontRecord = (TrueTypeFontIdentifier) record;
      fontName = ttfFontRecord.getFontName();
      if (compoundFontIdentifier != null)
      {
        bold = compoundFontIdentifier.isBoldSpecified();
        italic = compoundFontIdentifier.isItalicsSpecified();
      }
      else
      {
        bold = false;
        italic = false;
      }
    }
    else
    {
      throw new IllegalArgumentException("Unknown font-identifier type encountered.");
    }

    final BaseFont baseFont = baseFontSupport.createBaseFont
        (fontName, bold, italic, context.getEncoding(), context.isEmbedded());

    return new BaseFontFontMetrics(baseFont, (float) context.getFontSize());
  }
}
