# Generates default list of -E extensions from manpage.
# Does this by looking for the special comments 
# 'br START_EXT_LIST
# and
# 'br END_EXT_LIST
# in the manpage, and for all lines in between, recording every
# word on each line, except for the first word each line, as an extension,
# where a word is a whitespace-separated string of characters.
# See also the manpage comments surrounding the extension list.
$0 ~ "'br END_EXT_LIST" { p=0; }
p==1 {
 for(i=2; i<=NF; i++) { ex[nx++]=$i; }
}
$0 ~ "'br START_EXT_LIST" { p=1; }
END {
 print "/* This file was auto-generated by the Makefile, from the afio.1 manpage file */"
 for(i=0; i<nx; i++)
 {
  #a just-in-case consistency check.
  if((ex[i]==".I")||(ex[i]!~"^\\.")) {
     print "Questionable extention:"ex[i];
     print "Editing of afio.1 probably made it incompatible with"
     print "the parsing rules used by the exten_make.awk script.";
     exit 1;
  }
  print "struct extnode de"i+1"={ \""ex[i]"\", "(i?"&de"i:"NULL")" };";
 }
 print "struct extnode *compexts=&de"nx";";

}