/**
 * ===========================================
 * LibBase : a free Java utility library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libbase
 *
 * (C) Copyright 2007,2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * LFUMapTest
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */



package org.pentaho.reporting.libraries.util;

import junit.framework.TestCase;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.base.util.DebugLog;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public class LFUMapTest extends TestCase
{
  public LFUMapTest()
  {
  }

  public LFUMapTest(final String s)
  {
    super(s);
  }

  public void testAdd ()
  {
    final LFUMap lfuMap = new LFUMap(10);
    lfuMap.put("1", "1");
    lfuMap.validate();
    lfuMap.put("2", "2");
    lfuMap.validate();
    lfuMap.put("3", "3");
    lfuMap.validate();
    lfuMap.put("4", "4");
    lfuMap.validate();
    lfuMap.put("1", "5");
    lfuMap.validate();
    lfuMap.put("3", "6");
    lfuMap.validate();
    lfuMap.put("4", "7");
    lfuMap.validate();
    lfuMap.put("2", "8");
    lfuMap.validate();

    DebugLog.logHere();
  }

  public void testAdd2 ()
  {
    final LFUMap lfuMap = new LFUMap(10);
    lfuMap.put("1", "1");
    lfuMap.validate();
    lfuMap.put("2", "2");
    lfuMap.validate();
    lfuMap.put("3", "3");
    lfuMap.validate();
    lfuMap.put("4", "4");
    lfuMap.validate();
    lfuMap.put("1", "5");
    lfuMap.validate();
    lfuMap.put("3", "6");
    lfuMap.validate();
    lfuMap.put("4", "7");
    lfuMap.validate();
    lfuMap.put("a2", "8");
    lfuMap.validate();
    lfuMap.put("a4", "4");
    lfuMap.validate();
    lfuMap.put("a1", "5");
    lfuMap.validate();
    lfuMap.put("a3", "6");
    lfuMap.validate();
    lfuMap.put("b4", "7");
    lfuMap.validate();
    lfuMap.put("b4", "4");
    lfuMap.validate();
    lfuMap.put("b1", "5");
    lfuMap.validate();
    lfuMap.put("b3", "6");
    lfuMap.validate();
    lfuMap.put("c4", "7");
    lfuMap.validate();

    lfuMap.get("a2");
    lfuMap.validate();
    lfuMap.get("a4");
    lfuMap.validate();
    lfuMap.get("a1");
    lfuMap.validate();
    lfuMap.get("a3");
    lfuMap.validate();
    lfuMap.get("b4");
    lfuMap.validate();
    lfuMap.get("b4");
    lfuMap.validate();

  }

}
