/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class JavaMembers {
    private Class cl;
    private Hashtable members = new Hashtable(23);
    private Hashtable fieldAndMethods;
    private Hashtable staticMembers = new Hashtable(7);
    private Hashtable staticFieldAndMethods;
    MemberBox[] ctors;

    JavaMembers(Scriptable scope, Class cl) {
        this.cl = cl;
        this.reflect(scope);
    }

    boolean has(String name, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object obj = ht.get(name);
        if (obj != null) {
            return true;
        }
        return null != this.findExplicitFunction(name, isStatic);
    }

    Object get(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Class<?> type;
        Object rval;
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null && (member = this.getExplicitFunction(scope, name, javaObject, isStatic)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (member instanceof Scriptable) {
            return member;
        }
        Context cx = Context.getContext();
        try {
            if (member instanceof BeanProperty) {
                BeanProperty bp = (BeanProperty)member;
                rval = bp.getter.invoke(javaObject, null);
                type = bp.getter.method().getReturnType();
            } else {
                Field field = (Field)member;
                rval = field.get(isStatic ? null : javaObject);
                type = field.getType();
            }
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        scope = ScriptableObject.getTopLevelScope(scope);
        return cx.getWrapFactory().wrap(cx, scope, rval, type);
    }

    public void put(Scriptable scope, String name, Object javaObject, Object value, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null) {
            throw this.reportMemberNotFound(name);
        }
        if (member instanceof FieldAndMethods) {
            FieldAndMethods fam = (FieldAndMethods)ht.get(name);
            member = fam.field;
        }
        if (member instanceof BeanProperty) {
            BeanProperty bp = (BeanProperty)member;
            if (bp.setter == null) {
                throw this.reportMemberNotFound(name);
            }
            Class setType = bp.setter.argTypes[0];
            Object[] args = new Object[]{NativeJavaObject.coerceType(setType, value, true)};
            try {
                bp.setter.invoke(javaObject, args);
            }
            catch (Exception ex) {
                throw Context.throwAsScriptRuntimeEx(ex);
            }
        }
        if (!(member instanceof Field)) {
            String str = member == null ? "msg.java.internal.private" : "msg.java.method.assign";
            throw Context.reportRuntimeError1(str, name);
        }
        Field field = (Field)member;
        Object javaValue = NativeJavaObject.coerceType(field.getType(), value, true);
        try {
            field.set(javaObject, javaValue);
        }
        catch (IllegalAccessException accessEx) {
            throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
        }
        catch (IllegalArgumentException argEx) {
            throw Context.reportRuntimeError3("msg.java.internal.field.type", value.getClass().getName(), field, javaObject.getClass().getName());
        }
    }

    Object[] getIds(boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        int len = ht.size();
        Object[] result = new Object[len];
        Enumeration keys = ht.keys();
        int i = 0;
        while (i < len) {
            result[i] = keys.nextElement();
            ++i;
        }
        return result;
    }

    static String javaSignature(Class type) {
        if (!type.isArray()) {
            return type.getName();
        }
        int arrayDimension = 0;
        do {
            ++arrayDimension;
        } while ((type = type.getComponentType()).isArray());
        String name = type.getName();
        String suffix = "[]";
        if (arrayDimension == 1) {
            return name.concat(suffix);
        }
        int length = name.length() + arrayDimension * suffix.length();
        StringBuffer sb = new StringBuffer(length);
        sb.append(name);
        while (arrayDimension != 0) {
            --arrayDimension;
            sb.append(suffix);
        }
        return sb.toString();
    }

    static String liveConnectSignature(Class[] argTypes) {
        int N = argTypes.length;
        if (N == 0) {
            return "()";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int i = 0;
        while (i != N) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(JavaMembers.javaSignature(argTypes[i]));
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    private MemberBox findExplicitFunction(String name, boolean isStatic) {
        boolean isCtor;
        int sigStart = name.indexOf(40);
        if (sigStart < 0) {
            return null;
        }
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        MemberBox[] methodsOrCtors = null;
        boolean bl = isCtor = isStatic && sigStart == 0;
        if (isCtor) {
            methodsOrCtors = this.ctors;
        } else {
            String trueName = name.substring(0, sigStart);
            Object obj = ht.get(trueName);
            if (!isStatic && obj == null) {
                obj = this.staticMembers.get(trueName);
            }
            if (obj instanceof NativeJavaMethod) {
                NativeJavaMethod njm = (NativeJavaMethod)obj;
                methodsOrCtors = njm.methods;
            }
        }
        if (methodsOrCtors != null) {
            int i = 0;
            while (i < methodsOrCtors.length) {
                Class[] type = methodsOrCtors[i].argTypes;
                String sig = JavaMembers.liveConnectSignature(type);
                if (sigStart + sig.length() == name.length() && name.regionMatches(sigStart, sig, 0, sig.length())) {
                    return methodsOrCtors[i];
                }
                ++i;
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        BaseFunction member = null;
        MemberBox methodOrCtor = this.findExplicitFunction(name, isStatic);
        if (methodOrCtor != null) {
            Scriptable prototype = ScriptableObject.getFunctionPrototype(scope);
            if (methodOrCtor.isCtor()) {
                NativeJavaConstructor fun = new NativeJavaConstructor(methodOrCtor);
                fun.setPrototype(prototype);
                member = fun;
                ht.put(name, fun);
            } else {
                String trueName = methodOrCtor.getName();
                member = (BaseFunction)ht.get(trueName);
                if (member instanceof NativeJavaMethod && ((NativeJavaMethod)member).methods.length > 1) {
                    NativeJavaMethod fun = new NativeJavaMethod(methodOrCtor, name);
                    fun.setPrototype(prototype);
                    ht.put(name, fun);
                    member = fun;
                }
            }
        }
        return member;
    }

    private void reflect(Scriptable scope) {
        this.reflectMethods(scope);
        this.reflectFields(scope);
        this.makeBeanProperties(scope, false);
        this.makeBeanProperties(scope, true);
        this.reflectCtors(scope);
    }

    private void reflectMethods(Scriptable scope) {
        Method[] methods = this.cl.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            int mods = method.getModifiers();
            if (Modifier.isPublic(mods)) {
                String name;
                boolean isStatic = Modifier.isStatic(mods);
                Hashtable ht = isStatic ? this.staticMembers : this.members;
                Object value = ht.get(name = method.getName());
                if (value == null) {
                    ht.put(name, method);
                } else {
                    ObjArray overloadedMethods;
                    if (value instanceof ObjArray) {
                        overloadedMethods = (ObjArray)value;
                    } else {
                        if (!(value instanceof Method)) {
                            Kit.codeBug();
                        }
                        overloadedMethods = new ObjArray();
                        overloadedMethods.add(value);
                        ht.put(name, overloadedMethods);
                    }
                    overloadedMethods.add(method);
                }
            }
            ++i;
        }
        JavaMembers.initNativeMethods(this.staticMembers, scope);
        JavaMembers.initNativeMethods(this.members, scope);
    }

    private void reflectFields(Scriptable scope) {
        Field[] fields = this.cl.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if (Modifier.isPublic(mods)) {
                String name;
                boolean isStatic = Modifier.isStatic(mods);
                Hashtable ht = isStatic ? this.staticMembers : this.members;
                Object member = ht.get(name = field.getName());
                if (member == null) {
                    ht.put(name, field);
                } else if (member instanceof NativeJavaMethod) {
                    NativeJavaMethod method = (NativeJavaMethod)member;
                    FieldAndMethods fam = new FieldAndMethods(method.methods, field);
                    fam.setPrototype(ScriptableObject.getFunctionPrototype(scope));
                    this.getFieldAndMethodsTable(isStatic).put(name, fam);
                    ht.put(name, fam);
                } else if (member instanceof Field) {
                    Field oldField = (Field)member;
                    if (oldField.getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) {
                        ht.put(name, field);
                    }
                } else {
                    Kit.codeBug();
                }
            }
            ++i;
        }
    }

    private void makeBeanProperties(Scriptable scope, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Hashtable<String, BeanProperty> toAdd = new Hashtable<String, BeanProperty>();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object member;
            String nameComponent;
            String name = (String)e.nextElement();
            boolean memberIsGetMethod = name.startsWith("get");
            boolean memberIsIsMethod = name.startsWith("is");
            if (!memberIsGetMethod && !memberIsIsMethod || (nameComponent = name.substring(memberIsGetMethod ? 3 : 2)).length() == 0) continue;
            String beanPropertyName = nameComponent;
            char ch0 = nameComponent.charAt(0);
            if (Character.isUpperCase(ch0)) {
                if (nameComponent.length() == 1) {
                    beanPropertyName = nameComponent.toLowerCase();
                } else {
                    char ch1 = nameComponent.charAt(1);
                    if (!Character.isUpperCase(ch1)) {
                        beanPropertyName = Character.toLowerCase(ch0) + nameComponent.substring(1);
                    }
                }
            }
            if (ht.containsKey(beanPropertyName) || !((member = ht.get(name)) instanceof NativeJavaMethod)) continue;
            NativeJavaMethod njmGet = (NativeJavaMethod)member;
            MemberBox getter = JavaMembers.extractGetMethod(njmGet.methods, isStatic);
            if (getter == null) continue;
            NativeJavaMethod njmSet = null;
            MemberBox setter = null;
            String setterName = "set".concat(nameComponent);
            if (ht.containsKey(setterName) && (member = ht.get(setterName)) instanceof NativeJavaMethod) {
                njmSet = (NativeJavaMethod)member;
                Class<?> type = getter.method().getReturnType();
                setter = JavaMembers.extractSetMethod(type, njmSet.methods, isStatic);
            }
            BeanProperty bp = new BeanProperty(getter, setter);
            toAdd.put(beanPropertyName, bp);
        }
        Enumeration e2 = toAdd.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            Object value = toAdd.get(key);
            ht.put(key, value);
        }
    }

    private void reflectCtors(Scriptable scope) {
        Constructor<?>[] constructors = this.cl.getConstructors();
        int N = constructors.length;
        this.ctors = new MemberBox[N];
        ClassCache cache = ClassCache.get(scope);
        int i = 0;
        while (i != N) {
            this.ctors[i] = new MemberBox(constructors[i], cache);
            ++i;
        }
    }

    private static void initNativeMethods(Hashtable ht, Scriptable scope) {
        Enumeration e = ht.keys();
        ClassCache cache = ClassCache.get(scope);
        while (e.hasMoreElements()) {
            MemberBox[] methods;
            String name = (String)e.nextElement();
            Object value = ht.get(name);
            if (value instanceof Method) {
                methods = new MemberBox[]{new MemberBox((Method)value, cache)};
            } else {
                ObjArray overloadedMethods = (ObjArray)value;
                int N = overloadedMethods.size();
                if (N < 2) {
                    Kit.codeBug();
                }
                methods = new MemberBox[N];
                int i = 0;
                while (i != N) {
                    Method method = (Method)overloadedMethods.get(i);
                    methods[i] = new MemberBox(method, cache);
                    ++i;
                }
            }
            NativeJavaMethod fun = new NativeJavaMethod(methods);
            if (scope != null) {
                fun.setPrototype(ScriptableObject.getFunctionPrototype(scope));
            }
            ht.put(name, fun);
        }
    }

    private Hashtable getFieldAndMethodsTable(boolean isStatic) {
        Hashtable fmht;
        Hashtable hashtable = fmht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (fmht == null) {
            fmht = new Hashtable(11);
            if (isStatic) {
                this.staticFieldAndMethods = fmht;
            } else {
                this.fieldAndMethods = fmht;
            }
        }
        return fmht;
    }

    private static MemberBox extractGetMethod(MemberBox[] methods, boolean isStatic) {
        int methodIdx = 0;
        while (methodIdx < methods.length) {
            MemberBox method = methods[methodIdx];
            if (method.argTypes.length == 0 && (!isStatic || method.isStatic())) {
                Class<?> type = method.method().getReturnType();
                if (type == Void.TYPE) break;
                return method;
            }
            ++methodIdx;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class type, MemberBox[] methods, boolean isStatic) {
        int pass = 1;
        while (pass <= 2) {
            int i = 0;
            while (i < methods.length) {
                Class[] params;
                MemberBox method = methods[i];
                if ((!isStatic || method.isStatic()) && method.method().getReturnType() == Void.TYPE && (params = method.argTypes).length == 1) {
                    if (pass == 1) {
                        if (params[0] == type) {
                            return method;
                        }
                    } else {
                        if (pass != 2) {
                            Kit.codeBug();
                        }
                        if (params[0].isAssignableFrom(type)) {
                            return method;
                        }
                    }
                }
                ++i;
            }
            ++pass;
        }
        return null;
    }

    Hashtable getFieldAndMethodsObjects(Scriptable scope, Object javaObject, boolean isStatic) {
        Hashtable ht;
        Hashtable hashtable = ht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (ht == null) {
            return null;
        }
        int len = ht.size();
        Hashtable<String, FieldAndMethods> result = new Hashtable<String, FieldAndMethods>(len);
        Enumeration e = ht.elements();
        while (len-- > 0) {
            FieldAndMethods fam = (FieldAndMethods)e.nextElement();
            FieldAndMethods famNew = new FieldAndMethods(fam.methods, fam.field);
            famNew.javaObject = javaObject;
            result.put(fam.field.getName(), famNew);
        }
        return result;
    }

    static JavaMembers lookupClass(Scriptable scope, Class dynamicType, Class staticType) {
        JavaMembers members;
        ClassCache cache = ClassCache.get(scope);
        Hashtable ct = cache.classTable;
        Class cl = dynamicType;
        while (true) {
            if ((members = (JavaMembers)ct.get(cl)) != null) {
                return members;
            }
            try {
                members = new JavaMembers(scope, cl);
            }
            catch (SecurityException e) {
                if (staticType != null && staticType.isInterface()) {
                    cl = staticType;
                    staticType = null;
                    continue;
                }
                Class parent = cl.getSuperclass();
                if (parent == null) {
                    if (cl.isInterface()) {
                        parent = ScriptRuntime.ObjectClass;
                    } else {
                        throw e;
                    }
                }
                cl = parent;
                continue;
            }
            break;
        }
        if (cache.isCachingEnabled()) {
            ct.put(cl, members);
        }
        return members;
    }

    RuntimeException reportMemberNotFound(String memberName) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), memberName);
    }
}

