/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef koverartist_textstyle_h
#define koverartist_textstyle_h

#include <QtCore/qnamespace.h>
#include <QtGui/QColor>
#include <QtGui/QFont>

class QDomElement;
class QDomDocument;


namespace KoverArtist
{

/** A style of a text: font, color, alignment.
 */
class TextStyle
{
public:
   TextStyle();

   explicit TextStyle(const QFont& font, const QColor& color = Qt::black,
                      Qt::Alignment f = Qt::AlignCenter);

   TextStyle(const TextStyle&);

   TextStyle& operator=(const TextStyle&);

   /** Reset the object. */
   void clear();

   /** Get/set the font. */
   const QFont& font() const { return mFont; }
   void setFont(const QFont& f) { mFont = f; }

   /** Get/set the color. */
   const QColor& color() const { return mColor; }
   void setColor(const QColor& c) { mColor = c; }

   /** Get/set the alignment. */
   Qt::Alignment alignment() const { return mAlign; }
   void setAlignment(int f) { mAlign = (Qt::Alignment)f; }

   /** Fill the DOM element de with the object's contents. */
   void toDom(QDomDocument& doc, QDomElement& de) const;

   /** Set the object from the DOM element de. */
   bool fromDom(const QDomElement& de);

   /** Returns alignment flag f as string. */
   static const char* alignAsString(int f);

   /** Translates string str to alignment flag. */
   static Qt::Alignment alignFromString(const QString& str, Qt::Alignment defaultValue);

protected:
   QFont mFont;
   QColor mColor;
   Qt::Alignment mAlign;
};


} //namespace

#endif /*koverartist_textstyle_h*/
