/*
   Copyright (C) 2008-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
#ifndef taboptions_h
#define taboptions_h

#include "tabbase.h"

class KColorButton;
class EffectWidget;
class ImageWidget;
class QCheckBox;
class QLabel;
class TextStyleWidget;


/** The "options" side tab-page.
 */
class TabOptions: public TabBase
{
   typedef TabBase Inherited;
   Q_OBJECT

public:
   TabOptions(KoverArtist::Project* project, QWidget* parent = 0);
   virtual ~TabOptions();

public slots:
   /** Update the widget. */
   virtual void updateContents();

   /** Set the background color. */
   virtual void setBackgroundColor(const QColor&);

   /** Set the outline color. */
   virtual void setOutlineColor(const QColor&);

   /** Set "wrap image around front and back side" option. */
   virtual void setWrapImage(bool enable);

   /** Set "hide title text on front side" option. */
   virtual void setFrontTitleHide(bool enable);

private:
   TabOptions(const TabOptions&);
   TabOptions& operator=(const TabOptions&);

protected:
   KColorButton *mBtnBackground, *mBtnOutline;
   ImageWidget *mImwFront, *mImwBack;
   QCheckBox *mCbxWrapImage, *mCbxFrontTitleHide;
   QLabel *mLblCaptionBack;
   TextStyleWidget *mTswContents, *mTswSide;
   EffectWidget *mEffContents, *mEffSide;
};

#endif /*taboptions_h*/
