/*
   Copyright (C) 2006-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* rendertext.h
 */
#ifndef rendertext_h
#define rendertext_h

#include <qpainter.h>


namespace KoverArtist
{

class RendererBase;


/** Render a text.
 */
class RenderText
{
public:
   RenderText(const RendererBase* parent, const QFont& fnt, const QColor& c,
              const QRect& bb, Qt::AlignmentFlag f, const QString& txt,
	      int angle=0);

   virtual ~RenderText() {}

   /** Get/set angle in degrees. */
   int angle() const { return mAngle; }
   void setAngle(int arc) { mAngle = arc; }

   /** Render the text. */
   virtual void render(QPainter& p);

protected:
   const RendererBase *mParent;
   QRect mBB;
   Qt::AlignmentFlag mAlign;
   QString mText;
   QFont mFont;
   QColor mColor;
   int mAngle;
};


} //namespace

#endif /*rendertext_h*/
